/*
 * Decompiled with CFR 0.152.
 */
package io.github.some_example_name;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.viewport.FitViewport;
import io.github.some_example_name.GameScreen;
import io.github.some_example_name.MyGame;

public class TutorialScreen
implements Screen {
    private final MyGame game;
    private OrthographicCamera camera;
    private SpriteBatch batch;
    private Texture tutorialImage;
    private FitViewport viewport;
    private final int MENU_WIDTH = 790;
    private final int MENU_HEIGHT = 480;

    public TutorialScreen(MyGame game) {
        this.game = game;
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, 790.0f, 480.0f);
        this.batch = new SpriteBatch();
        this.tutorialImage = new Texture("How to Play Screen.png");
        this.viewport = new FitViewport(790.0f, 480.0f, this.camera);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        this.batch.draw(this.tutorialImage, 0.0f, 0.0f, 790.0f, 480.0f);
        this.batch.end();
        if (Gdx.input.isKeyJustPressed(62)) {
            this.game.setScreen(new GameScreen(this.game));
        } else if (Gdx.input.isKeyJustPressed(111)) {
            Gdx.app.exit();
        }
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.tutorialImage.dispose();
    }

    @Override
    public void show() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }
}

