/*
 * Decompiled with CFR 0.152.
 */
package io.github.some_example_name;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;

public class BusTicket {
    private Vector2 position;
    private Texture texture;
    private boolean isCollected;
    private boolean isDiscovered;

    public BusTicket(float x, float y) {
        this.position = new Vector2(x, y);
        this.texture = new Texture("bus-ticket.png");
        this.isCollected = false;
        this.isDiscovered = false;
    }

    public void render(SpriteBatch batch) {
        if (this.isDiscovered && !this.isCollected) {
            batch.draw(this.texture, this.position.x, this.position.y, 16.0f, 16.0f);
        }
    }

    public void renderAsIcon(SpriteBatch batch, OrthographicCamera camera) {
        if (this.isCollected) {
            float iconSize = 32.0f;
            float padding = 20.0f;
            float cornerX = camera.position.x + camera.viewportWidth / 2.0f * camera.zoom;
            float cornerY = camera.position.y + camera.viewportHeight / 2.0f * camera.zoom;
            float iconX = cornerX - iconSize - padding;
            float iconY = cornerY - iconSize - padding;
            batch.draw(this.texture, iconX, iconY, iconSize, iconSize);
        }
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public boolean isCollected() {
        return this.isCollected;
    }

    public void collect() {
        this.isCollected = true;
    }

    public void discover() {
        this.isDiscovered = true;
    }

    public void dispose() {
        this.texture.dispose();
    }
}

