/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.softbody;

import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.linearmath.btMatrix3x3FloatData;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3FloatData;
import com.badlogic.gdx.physics.bullet.softbody.SoftbodyJNI;
import java.nio.FloatBuffer;

public class SoftBodyPoseData
extends BulletBase {
    private long swigCPtr;

    protected SoftBodyPoseData(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public SoftBodyPoseData(long cPtr, boolean cMemoryOwn) {
        this("SoftBodyPoseData", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(SoftBodyPoseData obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SoftbodyJNI.delete_SoftBodyPoseData(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setRot(btMatrix3x3FloatData value) {
        SoftbodyJNI.SoftBodyPoseData_rot_set(this.swigCPtr, this, btMatrix3x3FloatData.getCPtr(value), value);
    }

    public btMatrix3x3FloatData getRot() {
        long cPtr = SoftbodyJNI.SoftBodyPoseData_rot_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btMatrix3x3FloatData(cPtr, false);
    }

    public void setScale(btMatrix3x3FloatData value) {
        SoftbodyJNI.SoftBodyPoseData_scale_set(this.swigCPtr, this, btMatrix3x3FloatData.getCPtr(value), value);
    }

    public btMatrix3x3FloatData getScale() {
        long cPtr = SoftbodyJNI.SoftBodyPoseData_scale_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btMatrix3x3FloatData(cPtr, false);
    }

    public void setAqq(btMatrix3x3FloatData value) {
        SoftbodyJNI.SoftBodyPoseData_aqq_set(this.swigCPtr, this, btMatrix3x3FloatData.getCPtr(value), value);
    }

    public btMatrix3x3FloatData getAqq() {
        long cPtr = SoftbodyJNI.SoftBodyPoseData_aqq_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btMatrix3x3FloatData(cPtr, false);
    }

    public void setCom(btVector3FloatData value) {
        SoftbodyJNI.SoftBodyPoseData_com_set(this.swigCPtr, this, btVector3FloatData.getCPtr(value), value);
    }

    public btVector3FloatData getCom() {
        long cPtr = SoftbodyJNI.SoftBodyPoseData_com_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3FloatData(cPtr, false);
    }

    public void setPositions(btVector3FloatData value) {
        SoftbodyJNI.SoftBodyPoseData_positions_set(this.swigCPtr, this, btVector3FloatData.getCPtr(value), value);
    }

    public btVector3FloatData getPositions() {
        long cPtr = SoftbodyJNI.SoftBodyPoseData_positions_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3FloatData(cPtr, false);
    }

    public void setWeights(FloatBuffer value) {
        assert (value.isDirect()) : "Buffer must be allocated direct.";
        SoftbodyJNI.SoftBodyPoseData_weights_set(this.swigCPtr, this, value);
    }

    public FloatBuffer getWeights() {
        return SoftbodyJNI.SoftBodyPoseData_weights_get(this.swigCPtr, this);
    }

    public void setNumPositions(int value) {
        SoftbodyJNI.SoftBodyPoseData_numPositions_set(this.swigCPtr, this, value);
    }

    public int getNumPositions() {
        return SoftbodyJNI.SoftBodyPoseData_numPositions_get(this.swigCPtr, this);
    }

    public void setNumWeigts(int value) {
        SoftbodyJNI.SoftBodyPoseData_numWeigts_set(this.swigCPtr, this, value);
    }

    public int getNumWeigts() {
        return SoftbodyJNI.SoftBodyPoseData_numWeigts_get(this.swigCPtr, this);
    }

    public void setBvolume(int value) {
        SoftbodyJNI.SoftBodyPoseData_bvolume_set(this.swigCPtr, this, value);
    }

    public int getBvolume() {
        return SoftbodyJNI.SoftBodyPoseData_bvolume_get(this.swigCPtr, this);
    }

    public void setBframe(int value) {
        SoftbodyJNI.SoftBodyPoseData_bframe_set(this.swigCPtr, this, value);
    }

    public int getBframe() {
        return SoftbodyJNI.SoftBodyPoseData_bframe_get(this.swigCPtr, this);
    }

    public void setRestVolume(float value) {
        SoftbodyJNI.SoftBodyPoseData_restVolume_set(this.swigCPtr, this, value);
    }

    public float getRestVolume() {
        return SoftbodyJNI.SoftBodyPoseData_restVolume_get(this.swigCPtr, this);
    }

    public void setPad(int value) {
        SoftbodyJNI.SoftBodyPoseData_pad_set(this.swigCPtr, this, value);
    }

    public int getPad() {
        return SoftbodyJNI.SoftBodyPoseData_pad_get(this.swigCPtr, this);
    }

    public SoftBodyPoseData() {
        this(SoftbodyJNI.new_SoftBodyPoseData(), true);
    }
}

