/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.softbody;

import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3FloatData;
import com.badlogic.gdx.physics.bullet.softbody.SoftBodyMaterialData;
import com.badlogic.gdx.physics.bullet.softbody.SoftbodyJNI;

public class SoftBodyNodeData
extends BulletBase {
    private long swigCPtr;

    protected SoftBodyNodeData(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public SoftBodyNodeData(long cPtr, boolean cMemoryOwn) {
        this("SoftBodyNodeData", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(SoftBodyNodeData obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SoftbodyJNI.delete_SoftBodyNodeData(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setMaterial(SoftBodyMaterialData value) {
        SoftbodyJNI.SoftBodyNodeData_material_set(this.swigCPtr, this, SoftBodyMaterialData.getCPtr(value), value);
    }

    public SoftBodyMaterialData getMaterial() {
        long cPtr = SoftbodyJNI.SoftBodyNodeData_material_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new SoftBodyMaterialData(cPtr, false);
    }

    public void setPosition(btVector3FloatData value) {
        SoftbodyJNI.SoftBodyNodeData_position_set(this.swigCPtr, this, btVector3FloatData.getCPtr(value), value);
    }

    public btVector3FloatData getPosition() {
        long cPtr = SoftbodyJNI.SoftBodyNodeData_position_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3FloatData(cPtr, false);
    }

    public void setPreviousPosition(btVector3FloatData value) {
        SoftbodyJNI.SoftBodyNodeData_previousPosition_set(this.swigCPtr, this, btVector3FloatData.getCPtr(value), value);
    }

    public btVector3FloatData getPreviousPosition() {
        long cPtr = SoftbodyJNI.SoftBodyNodeData_previousPosition_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3FloatData(cPtr, false);
    }

    public void setVelocity(btVector3FloatData value) {
        SoftbodyJNI.SoftBodyNodeData_velocity_set(this.swigCPtr, this, btVector3FloatData.getCPtr(value), value);
    }

    public btVector3FloatData getVelocity() {
        long cPtr = SoftbodyJNI.SoftBodyNodeData_velocity_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3FloatData(cPtr, false);
    }

    public void setAccumulatedForce(btVector3FloatData value) {
        SoftbodyJNI.SoftBodyNodeData_accumulatedForce_set(this.swigCPtr, this, btVector3FloatData.getCPtr(value), value);
    }

    public btVector3FloatData getAccumulatedForce() {
        long cPtr = SoftbodyJNI.SoftBodyNodeData_accumulatedForce_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3FloatData(cPtr, false);
    }

    public void setNormal(btVector3FloatData value) {
        SoftbodyJNI.SoftBodyNodeData_normal_set(this.swigCPtr, this, btVector3FloatData.getCPtr(value), value);
    }

    public btVector3FloatData getNormal() {
        long cPtr = SoftbodyJNI.SoftBodyNodeData_normal_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3FloatData(cPtr, false);
    }

    public void setInverseMass(float value) {
        SoftbodyJNI.SoftBodyNodeData_inverseMass_set(this.swigCPtr, this, value);
    }

    public float getInverseMass() {
        return SoftbodyJNI.SoftBodyNodeData_inverseMass_get(this.swigCPtr, this);
    }

    public void setArea(float value) {
        SoftbodyJNI.SoftBodyNodeData_area_set(this.swigCPtr, this, value);
    }

    public float getArea() {
        return SoftbodyJNI.SoftBodyNodeData_area_get(this.swigCPtr, this);
    }

    public void setAttach(int value) {
        SoftbodyJNI.SoftBodyNodeData_attach_set(this.swigCPtr, this, value);
    }

    public int getAttach() {
        return SoftbodyJNI.SoftBodyNodeData_attach_get(this.swigCPtr, this);
    }

    public void setPad(int value) {
        SoftbodyJNI.SoftBodyNodeData_pad_set(this.swigCPtr, this, value);
    }

    public int getPad() {
        return SoftbodyJNI.SoftBodyNodeData_pad_get(this.swigCPtr, this);
    }

    public SoftBodyNodeData() {
        this(SoftbodyJNI.new_SoftBodyNodeData(), true);
    }
}

