/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.softbody;

import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.softbody.SoftBodyMaterialData;
import com.badlogic.gdx.physics.bullet.softbody.SoftbodyJNI;

public class SoftBodyLinkData
extends BulletBase {
    private long swigCPtr;

    protected SoftBodyLinkData(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public SoftBodyLinkData(long cPtr, boolean cMemoryOwn) {
        this("SoftBodyLinkData", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(SoftBodyLinkData obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SoftbodyJNI.delete_SoftBodyLinkData(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setMaterial(SoftBodyMaterialData value) {
        SoftbodyJNI.SoftBodyLinkData_material_set(this.swigCPtr, this, SoftBodyMaterialData.getCPtr(value), value);
    }

    public SoftBodyMaterialData getMaterial() {
        long cPtr = SoftbodyJNI.SoftBodyLinkData_material_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new SoftBodyMaterialData(cPtr, false);
    }

    public void setNodeIndices(int[] value) {
        SoftbodyJNI.SoftBodyLinkData_nodeIndices_set(this.swigCPtr, this, value);
    }

    public int[] getNodeIndices() {
        return SoftbodyJNI.SoftBodyLinkData_nodeIndices_get(this.swigCPtr, this);
    }

    public void setRestLength(float value) {
        SoftbodyJNI.SoftBodyLinkData_restLength_set(this.swigCPtr, this, value);
    }

    public float getRestLength() {
        return SoftbodyJNI.SoftBodyLinkData_restLength_get(this.swigCPtr, this);
    }

    public void setBbending(int value) {
        SoftbodyJNI.SoftBodyLinkData_bbending_set(this.swigCPtr, this, value);
    }

    public int getBbending() {
        return SoftbodyJNI.SoftBodyLinkData_bbending_get(this.swigCPtr, this);
    }

    public SoftBodyLinkData() {
        this(SoftbodyJNI.new_SoftBodyLinkData(), true);
    }
}

