/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.linearmath;

import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.linearmath.LinearMathJNI;
import com.badlogic.gdx.physics.bullet.linearmath.btChunk;
import java.nio.ByteBuffer;

public class btSerializer
extends BulletBase {
    private long swigCPtr;

    protected btSerializer(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btSerializer(long cPtr, boolean cMemoryOwn) {
        this("btSerializer", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btSerializer obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LinearMathJNI.delete_btSerializer(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public ByteBuffer getBufferPointer() {
        return LinearMathJNI.btSerializer_getBufferPointer(this.swigCPtr, this);
    }

    public int getCurrentBufferSize() {
        return LinearMathJNI.btSerializer_getCurrentBufferSize(this.swigCPtr, this);
    }

    public btChunk allocate(long size, int numElements) {
        long cPtr = LinearMathJNI.btSerializer_allocate(this.swigCPtr, this, size, numElements);
        return cPtr == 0L ? null : new btChunk(cPtr, false);
    }

    public void finalizeChunk(btChunk chunk, String structType, int chunkCode, long oldPtr) {
        LinearMathJNI.btSerializer_finalizeChunk(this.swigCPtr, this, btChunk.getCPtr(chunk), chunk, structType, chunkCode, oldPtr);
    }

    public long findPointer(long oldPtr) {
        return LinearMathJNI.btSerializer_findPointer(this.swigCPtr, this, oldPtr);
    }

    public long getUniquePointer(long oldPtr) {
        return LinearMathJNI.btSerializer_getUniquePointer(this.swigCPtr, this, oldPtr);
    }

    public void startSerialization() {
        LinearMathJNI.btSerializer_startSerialization(this.swigCPtr, this);
    }

    public void finishSerialization() {
        LinearMathJNI.btSerializer_finishSerialization(this.swigCPtr, this);
    }

    public String findNameForPointer(long ptr) {
        return LinearMathJNI.btSerializer_findNameForPointer(this.swigCPtr, this, ptr);
    }

    public void registerNameForPointer(long ptr, String name) {
        LinearMathJNI.btSerializer_registerNameForPointer(this.swigCPtr, this, ptr, name);
    }

    public void serializeName(String ptr) {
        LinearMathJNI.btSerializer_serializeName(this.swigCPtr, this, ptr);
    }

    public int getSerializationFlags() {
        return LinearMathJNI.btSerializer_getSerializationFlags(this.swigCPtr, this);
    }

    public void setSerializationFlags(int flags) {
        LinearMathJNI.btSerializer_setSerializationFlags(this.swigCPtr, this, flags);
    }

    public int getNumChunks() {
        return LinearMathJNI.btSerializer_getNumChunks(this.swigCPtr, this);
    }

    public btChunk getChunk(int chunkIndex) {
        long cPtr = LinearMathJNI.btSerializer_getChunk(this.swigCPtr, this, chunkIndex);
        return cPtr == 0L ? null : new btChunk(cPtr, false);
    }
}

