/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.dynamics;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.dynamics.DynamicsJNI;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;

public class btTranslationalLimitMotor
extends BulletBase {
    private long swigCPtr;

    protected btTranslationalLimitMotor(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btTranslationalLimitMotor(long cPtr, boolean cMemoryOwn) {
        this("btTranslationalLimitMotor", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btTranslationalLimitMotor obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                DynamicsJNI.delete_btTranslationalLimitMotor(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setLowerLimit(btVector3 value) {
        DynamicsJNI.btTranslationalLimitMotor_lowerLimit_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getLowerLimit() {
        long cPtr = DynamicsJNI.btTranslationalLimitMotor_lowerLimit_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setUpperLimit(btVector3 value) {
        DynamicsJNI.btTranslationalLimitMotor_upperLimit_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getUpperLimit() {
        long cPtr = DynamicsJNI.btTranslationalLimitMotor_upperLimit_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setAccumulatedImpulse(btVector3 value) {
        DynamicsJNI.btTranslationalLimitMotor_accumulatedImpulse_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getAccumulatedImpulse() {
        long cPtr = DynamicsJNI.btTranslationalLimitMotor_accumulatedImpulse_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setLimitSoftness(float value) {
        DynamicsJNI.btTranslationalLimitMotor_limitSoftness_set(this.swigCPtr, this, value);
    }

    public float getLimitSoftness() {
        return DynamicsJNI.btTranslationalLimitMotor_limitSoftness_get(this.swigCPtr, this);
    }

    public void setDamping(float value) {
        DynamicsJNI.btTranslationalLimitMotor_damping_set(this.swigCPtr, this, value);
    }

    public float getDamping() {
        return DynamicsJNI.btTranslationalLimitMotor_damping_get(this.swigCPtr, this);
    }

    public void setRestitution(float value) {
        DynamicsJNI.btTranslationalLimitMotor_restitution_set(this.swigCPtr, this, value);
    }

    public float getRestitution() {
        return DynamicsJNI.btTranslationalLimitMotor_restitution_get(this.swigCPtr, this);
    }

    public void setNormalCFM(btVector3 value) {
        DynamicsJNI.btTranslationalLimitMotor_normalCFM_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getNormalCFM() {
        long cPtr = DynamicsJNI.btTranslationalLimitMotor_normalCFM_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setStopERP(btVector3 value) {
        DynamicsJNI.btTranslationalLimitMotor_stopERP_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getStopERP() {
        long cPtr = DynamicsJNI.btTranslationalLimitMotor_stopERP_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setStopCFM(btVector3 value) {
        DynamicsJNI.btTranslationalLimitMotor_stopCFM_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getStopCFM() {
        long cPtr = DynamicsJNI.btTranslationalLimitMotor_stopCFM_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setEnableMotor(boolean[] value) {
        DynamicsJNI.btTranslationalLimitMotor_enableMotor_set(this.swigCPtr, this, value);
    }

    public boolean[] getEnableMotor() {
        return DynamicsJNI.btTranslationalLimitMotor_enableMotor_get(this.swigCPtr, this);
    }

    public void setTargetVelocity(btVector3 value) {
        DynamicsJNI.btTranslationalLimitMotor_targetVelocity_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getTargetVelocity() {
        long cPtr = DynamicsJNI.btTranslationalLimitMotor_targetVelocity_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setMaxMotorForce(btVector3 value) {
        DynamicsJNI.btTranslationalLimitMotor_maxMotorForce_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getMaxMotorForce() {
        long cPtr = DynamicsJNI.btTranslationalLimitMotor_maxMotorForce_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setCurrentLimitError(btVector3 value) {
        DynamicsJNI.btTranslationalLimitMotor_currentLimitError_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getCurrentLimitError() {
        long cPtr = DynamicsJNI.btTranslationalLimitMotor_currentLimitError_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setCurrentLinearDiff(btVector3 value) {
        DynamicsJNI.btTranslationalLimitMotor_currentLinearDiff_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getCurrentLinearDiff() {
        long cPtr = DynamicsJNI.btTranslationalLimitMotor_currentLinearDiff_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setCurrentLimit(int[] value) {
        DynamicsJNI.btTranslationalLimitMotor_currentLimit_set(this.swigCPtr, this, value);
    }

    public int[] getCurrentLimit() {
        return DynamicsJNI.btTranslationalLimitMotor_currentLimit_get(this.swigCPtr, this);
    }

    public btTranslationalLimitMotor() {
        this(DynamicsJNI.new_btTranslationalLimitMotor__SWIG_0(), true);
    }

    public btTranslationalLimitMotor(btTranslationalLimitMotor other) {
        this(DynamicsJNI.new_btTranslationalLimitMotor__SWIG_1(btTranslationalLimitMotor.getCPtr(other), other), true);
    }

    public boolean isLimited(int limitIndex) {
        return DynamicsJNI.btTranslationalLimitMotor_isLimited(this.swigCPtr, this, limitIndex);
    }

    public boolean needApplyForce(int limitIndex) {
        return DynamicsJNI.btTranslationalLimitMotor_needApplyForce(this.swigCPtr, this, limitIndex);
    }

    public int testLimitValue(int limitIndex, float test_value) {
        return DynamicsJNI.btTranslationalLimitMotor_testLimitValue(this.swigCPtr, this, limitIndex, test_value);
    }

    public float solveLinearAxis(float timeStep, float jacDiagABInv, btRigidBody body1, Vector3 pointInA, btRigidBody body2, Vector3 pointInB, int limit_index, Vector3 axis_normal_on_a, Vector3 anchorPos) {
        return DynamicsJNI.btTranslationalLimitMotor_solveLinearAxis(this.swigCPtr, this, timeStep, jacDiagABInv, btRigidBody.getCPtr(body1), body1, pointInA, btRigidBody.getCPtr(body2), body2, pointInB, limit_index, axis_normal_on_a, anchorPos);
    }
}

