/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.dynamics;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.dynamics.DynamicsJNI;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import com.badlogic.gdx.physics.bullet.linearmath.btTransform;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;

public class btSolverBody
extends BulletBase {
    private long swigCPtr;

    protected btSolverBody(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btSolverBody(long cPtr, boolean cMemoryOwn) {
        this("btSolverBody", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btSolverBody obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                DynamicsJNI.delete_btSolverBody(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public long operatorNew(long sizeInBytes) {
        return DynamicsJNI.btSolverBody_operatorNew__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDelete(long ptr) {
        DynamicsJNI.btSolverBody_operatorDelete__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNew(long arg0, long ptr) {
        return DynamicsJNI.btSolverBody_operatorNew__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDelete(long arg0, long arg1) {
        DynamicsJNI.btSolverBody_operatorDelete__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public long operatorNewArray(long sizeInBytes) {
        return DynamicsJNI.btSolverBody_operatorNewArray__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDeleteArray(long ptr) {
        DynamicsJNI.btSolverBody_operatorDeleteArray__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNewArray(long arg0, long ptr) {
        return DynamicsJNI.btSolverBody_operatorNewArray__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDeleteArray(long arg0, long arg1) {
        DynamicsJNI.btSolverBody_operatorDeleteArray__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public void setWorldTransform(btTransform value) {
        DynamicsJNI.btSolverBody_worldTransform_set(this.swigCPtr, this, btTransform.getCPtr(value), value);
    }

    public btTransform getWorldTransform() {
        long cPtr = DynamicsJNI.btSolverBody_worldTransform_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btTransform(cPtr, false);
    }

    public void setDeltaLinearVelocity(btVector3 value) {
        DynamicsJNI.btSolverBody_deltaLinearVelocity_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getDeltaLinearVelocity() {
        long cPtr = DynamicsJNI.btSolverBody_deltaLinearVelocity_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setDeltaAngularVelocity(btVector3 value) {
        DynamicsJNI.btSolverBody_deltaAngularVelocity_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getDeltaAngularVelocity() {
        long cPtr = DynamicsJNI.btSolverBody_deltaAngularVelocity_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setAngularFactor(btVector3 value) {
        DynamicsJNI.btSolverBody_angularFactor_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getAngularFactor() {
        long cPtr = DynamicsJNI.btSolverBody_angularFactor_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setLinearFactor(btVector3 value) {
        DynamicsJNI.btSolverBody_linearFactor_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getLinearFactor() {
        long cPtr = DynamicsJNI.btSolverBody_linearFactor_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setInvMass(btVector3 value) {
        DynamicsJNI.btSolverBody_invMass_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getInvMass() {
        long cPtr = DynamicsJNI.btSolverBody_invMass_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setPushVelocity(btVector3 value) {
        DynamicsJNI.btSolverBody_pushVelocity_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getPushVelocity() {
        long cPtr = DynamicsJNI.btSolverBody_pushVelocity_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setTurnVelocity(btVector3 value) {
        DynamicsJNI.btSolverBody_turnVelocity_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getTurnVelocity() {
        long cPtr = DynamicsJNI.btSolverBody_turnVelocity_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setLinearVelocity(btVector3 value) {
        DynamicsJNI.btSolverBody_linearVelocity_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getLinearVelocity() {
        long cPtr = DynamicsJNI.btSolverBody_linearVelocity_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setAngularVelocity(btVector3 value) {
        DynamicsJNI.btSolverBody_angularVelocity_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getAngularVelocity() {
        long cPtr = DynamicsJNI.btSolverBody_angularVelocity_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setExternalForceImpulse(btVector3 value) {
        DynamicsJNI.btSolverBody_externalForceImpulse_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getExternalForceImpulse() {
        long cPtr = DynamicsJNI.btSolverBody_externalForceImpulse_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setExternalTorqueImpulse(btVector3 value) {
        DynamicsJNI.btSolverBody_externalTorqueImpulse_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getExternalTorqueImpulse() {
        long cPtr = DynamicsJNI.btSolverBody_externalTorqueImpulse_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setOriginalBody(btRigidBody value) {
        DynamicsJNI.btSolverBody_originalBody_set(this.swigCPtr, this, btRigidBody.getCPtr(value), value);
    }

    public btRigidBody getOriginalBody() {
        return btRigidBody.getInstance(DynamicsJNI.btSolverBody_originalBody_get(this.swigCPtr, this), false);
    }

    public void getVelocityInLocalPointNoDelta(Vector3 rel_pos, Vector3 velocity) {
        DynamicsJNI.btSolverBody_getVelocityInLocalPointNoDelta(this.swigCPtr, this, rel_pos, velocity);
    }

    public void getVelocityInLocalPointObsolete(Vector3 rel_pos, Vector3 velocity) {
        DynamicsJNI.btSolverBody_getVelocityInLocalPointObsolete(this.swigCPtr, this, rel_pos, velocity);
    }

    public void getAngularVelocity(Vector3 angVel) {
        DynamicsJNI.btSolverBody_getAngularVelocity(this.swigCPtr, this, angVel);
    }

    public void applyImpulse(Vector3 linearComponent, Vector3 angularComponent, float impulseMagnitude) {
        DynamicsJNI.btSolverBody_applyImpulse(this.swigCPtr, this, linearComponent, angularComponent, impulseMagnitude);
    }

    public void internalApplyPushImpulse(Vector3 linearComponent, Vector3 angularComponent, float impulseMagnitude) {
        DynamicsJNI.btSolverBody_internalApplyPushImpulse(this.swigCPtr, this, linearComponent, angularComponent, impulseMagnitude);
    }

    public Vector3 internalGetDeltaLinearVelocity() {
        return DynamicsJNI.btSolverBody_internalGetDeltaLinearVelocity(this.swigCPtr, this);
    }

    public Vector3 internalGetDeltaAngularVelocity() {
        return DynamicsJNI.btSolverBody_internalGetDeltaAngularVelocity(this.swigCPtr, this);
    }

    public Vector3 internalGetAngularFactor() {
        return DynamicsJNI.btSolverBody_internalGetAngularFactor(this.swigCPtr, this);
    }

    public Vector3 internalGetInvMass() {
        return DynamicsJNI.btSolverBody_internalGetInvMass(this.swigCPtr, this);
    }

    public void internalSetInvMass(Vector3 invMass) {
        DynamicsJNI.btSolverBody_internalSetInvMass(this.swigCPtr, this, invMass);
    }

    public Vector3 internalGetPushVelocity() {
        return DynamicsJNI.btSolverBody_internalGetPushVelocity(this.swigCPtr, this);
    }

    public Vector3 internalGetTurnVelocity() {
        return DynamicsJNI.btSolverBody_internalGetTurnVelocity(this.swigCPtr, this);
    }

    public void internalGetVelocityInLocalPointObsolete(Vector3 rel_pos, Vector3 velocity) {
        DynamicsJNI.btSolverBody_internalGetVelocityInLocalPointObsolete(this.swigCPtr, this, rel_pos, velocity);
    }

    public void internalGetAngularVelocity(Vector3 angVel) {
        DynamicsJNI.btSolverBody_internalGetAngularVelocity(this.swigCPtr, this, angVel);
    }

    public void internalApplyImpulse(Vector3 linearComponent, Vector3 angularComponent, float impulseMagnitude) {
        DynamicsJNI.btSolverBody_internalApplyImpulse(this.swigCPtr, this, linearComponent, angularComponent, impulseMagnitude);
    }

    public void writebackVelocity() {
        DynamicsJNI.btSolverBody_writebackVelocity(this.swigCPtr, this);
    }

    public void writebackVelocityAndTransform(float timeStep, float splitImpulseTurnErp) {
        DynamicsJNI.btSolverBody_writebackVelocityAndTransform(this.swigCPtr, this, timeStep, splitImpulseTurnErp);
    }

    public btSolverBody() {
        this(DynamicsJNI.new_btSolverBody(), true);
    }
}

