/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.dynamics;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.dynamics.DynamicsJNI;
import com.badlogic.gdx.physics.bullet.dynamics.SWIGTYPE_p_btAlignedObjectArrayT_btWheelInfo_t;
import com.badlogic.gdx.physics.bullet.dynamics.btActionInterface;
import com.badlogic.gdx.physics.bullet.dynamics.btRigidBody;
import com.badlogic.gdx.physics.bullet.dynamics.btVehicleRaycaster;
import com.badlogic.gdx.physics.bullet.dynamics.btWheelInfo;

public class btRaycastVehicle
extends btActionInterface {
    private long swigCPtr;

    protected btRaycastVehicle(String className, long cPtr, boolean cMemoryOwn) {
        super(className, DynamicsJNI.btRaycastVehicle_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btRaycastVehicle(long cPtr, boolean cMemoryOwn) {
        this("btRaycastVehicle", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(DynamicsJNI.btRaycastVehicle_SWIGUpcast(this.swigCPtr), cMemoryOwn);
    }

    public static long getCPtr(btRaycastVehicle obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                DynamicsJNI.delete_btRaycastVehicle(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public btRaycastVehicle(btVehicleTuning tuning, btRigidBody chassis, btVehicleRaycaster raycaster) {
        this(DynamicsJNI.new_btRaycastVehicle(btVehicleTuning.getCPtr(tuning), tuning, btRigidBody.getCPtr(chassis), chassis, btVehicleRaycaster.getCPtr(raycaster), raycaster), true);
    }

    public Matrix4 getChassisWorldTransform() {
        return DynamicsJNI.btRaycastVehicle_getChassisWorldTransform(this.swigCPtr, this);
    }

    public float rayCast(btWheelInfo wheel) {
        return DynamicsJNI.btRaycastVehicle_rayCast(this.swigCPtr, this, btWheelInfo.getCPtr(wheel), wheel);
    }

    public void updateVehicle(float step) {
        DynamicsJNI.btRaycastVehicle_updateVehicle(this.swigCPtr, this, step);
    }

    public void resetSuspension() {
        DynamicsJNI.btRaycastVehicle_resetSuspension(this.swigCPtr, this);
    }

    public float getSteeringValue(int wheel) {
        return DynamicsJNI.btRaycastVehicle_getSteeringValue(this.swigCPtr, this, wheel);
    }

    public void setSteeringValue(float steering, int wheel) {
        DynamicsJNI.btRaycastVehicle_setSteeringValue(this.swigCPtr, this, steering, wheel);
    }

    public void applyEngineForce(float force, int wheel) {
        DynamicsJNI.btRaycastVehicle_applyEngineForce(this.swigCPtr, this, force, wheel);
    }

    public Matrix4 getWheelTransformWS(int wheelIndex) {
        return DynamicsJNI.btRaycastVehicle_getWheelTransformWS(this.swigCPtr, this, wheelIndex);
    }

    public void updateWheelTransform(int wheelIndex, boolean interpolatedTransform) {
        DynamicsJNI.btRaycastVehicle_updateWheelTransform__SWIG_0(this.swigCPtr, this, wheelIndex, interpolatedTransform);
    }

    public void updateWheelTransform(int wheelIndex) {
        DynamicsJNI.btRaycastVehicle_updateWheelTransform__SWIG_1(this.swigCPtr, this, wheelIndex);
    }

    public btWheelInfo addWheel(Vector3 connectionPointCS0, Vector3 wheelDirectionCS0, Vector3 wheelAxleCS, float suspensionRestLength, float wheelRadius, btVehicleTuning tuning, boolean isFrontWheel) {
        return new btWheelInfo(DynamicsJNI.btRaycastVehicle_addWheel(this.swigCPtr, this, connectionPointCS0, wheelDirectionCS0, wheelAxleCS, suspensionRestLength, wheelRadius, btVehicleTuning.getCPtr(tuning), tuning, isFrontWheel), false);
    }

    public int getNumWheels() {
        return DynamicsJNI.btRaycastVehicle_getNumWheels(this.swigCPtr, this);
    }

    public void setWheelInfo(SWIGTYPE_p_btAlignedObjectArrayT_btWheelInfo_t value) {
        DynamicsJNI.btRaycastVehicle_wheelInfo_set(this.swigCPtr, this, SWIGTYPE_p_btAlignedObjectArrayT_btWheelInfo_t.getCPtr(value));
    }

    public SWIGTYPE_p_btAlignedObjectArrayT_btWheelInfo_t getWheelInfo() {
        long cPtr = DynamicsJNI.btRaycastVehicle_wheelInfo_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new SWIGTYPE_p_btAlignedObjectArrayT_btWheelInfo_t(cPtr, false);
    }

    public btWheelInfo getWheelInfo(int index) {
        return new btWheelInfo(DynamicsJNI.btRaycastVehicle_getWheelInfo(this.swigCPtr, this, index), false);
    }

    public btWheelInfo getWheelInfoConst(int index) {
        return new btWheelInfo(DynamicsJNI.btRaycastVehicle_getWheelInfoConst(this.swigCPtr, this, index), false);
    }

    public void updateWheelTransformsWS(btWheelInfo wheel, boolean interpolatedTransform) {
        DynamicsJNI.btRaycastVehicle_updateWheelTransformsWS__SWIG_0(this.swigCPtr, this, btWheelInfo.getCPtr(wheel), wheel, interpolatedTransform);
    }

    public void updateWheelTransformsWS(btWheelInfo wheel) {
        DynamicsJNI.btRaycastVehicle_updateWheelTransformsWS__SWIG_1(this.swigCPtr, this, btWheelInfo.getCPtr(wheel), wheel);
    }

    public void setBrake(float brake, int wheelIndex) {
        DynamicsJNI.btRaycastVehicle_setBrake(this.swigCPtr, this, brake, wheelIndex);
    }

    public void setPitchControl(float pitch) {
        DynamicsJNI.btRaycastVehicle_setPitchControl(this.swigCPtr, this, pitch);
    }

    public void updateSuspension(float deltaTime) {
        DynamicsJNI.btRaycastVehicle_updateSuspension(this.swigCPtr, this, deltaTime);
    }

    public void updateFriction(float timeStep) {
        DynamicsJNI.btRaycastVehicle_updateFriction(this.swigCPtr, this, timeStep);
    }

    public btRigidBody getRigidBody() {
        return btRigidBody.getInstance(DynamicsJNI.btRaycastVehicle_getRigidBody(this.swigCPtr, this), false);
    }

    public btRigidBody getRigidBodyConst() {
        return btRigidBody.getInstance(DynamicsJNI.btRaycastVehicle_getRigidBodyConst(this.swigCPtr, this), false);
    }

    public int getRightAxis() {
        return DynamicsJNI.btRaycastVehicle_getRightAxis(this.swigCPtr, this);
    }

    public int getUpAxis() {
        return DynamicsJNI.btRaycastVehicle_getUpAxis(this.swigCPtr, this);
    }

    public int getForwardAxis() {
        return DynamicsJNI.btRaycastVehicle_getForwardAxis(this.swigCPtr, this);
    }

    public Vector3 getForwardVector() {
        return DynamicsJNI.btRaycastVehicle_getForwardVector(this.swigCPtr, this);
    }

    public float getCurrentSpeedKmHour() {
        return DynamicsJNI.btRaycastVehicle_getCurrentSpeedKmHour(this.swigCPtr, this);
    }

    public void setCoordinateSystem(int rightIndex, int upIndex, int forwardIndex) {
        DynamicsJNI.btRaycastVehicle_setCoordinateSystem(this.swigCPtr, this, rightIndex, upIndex, forwardIndex);
    }

    public int getUserConstraintType() {
        return DynamicsJNI.btRaycastVehicle_getUserConstraintType(this.swigCPtr, this);
    }

    public void setUserConstraintType(int userConstraintType) {
        DynamicsJNI.btRaycastVehicle_setUserConstraintType(this.swigCPtr, this, userConstraintType);
    }

    public void setUserConstraintId(int uid) {
        DynamicsJNI.btRaycastVehicle_setUserConstraintId(this.swigCPtr, this, uid);
    }

    public int getUserConstraintId() {
        return DynamicsJNI.btRaycastVehicle_getUserConstraintId(this.swigCPtr, this);
    }

    public static class btVehicleTuning
    extends BulletBase {
        private long swigCPtr;

        protected btVehicleTuning(String className, long cPtr, boolean cMemoryOwn) {
            super(className, cPtr, cMemoryOwn);
            this.swigCPtr = cPtr;
        }

        public btVehicleTuning(long cPtr, boolean cMemoryOwn) {
            this("btVehicleTuning", cPtr, cMemoryOwn);
            this.construct();
        }

        @Override
        protected void reset(long cPtr, boolean cMemoryOwn) {
            if (!this.destroyed) {
                this.destroy();
            }
            this.swigCPtr = cPtr;
            super.reset(this.swigCPtr, cMemoryOwn);
        }

        public static long getCPtr(btVehicleTuning obj) {
            return obj == null ? 0L : obj.swigCPtr;
        }

        @Override
        protected void finalize() throws Throwable {
            if (!this.destroyed) {
                this.destroy();
            }
            super.finalize();
        }

        @Override
        protected synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    DynamicsJNI.delete_btRaycastVehicle_btVehicleTuning(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public btVehicleTuning() {
            this(DynamicsJNI.new_btRaycastVehicle_btVehicleTuning(), true);
        }

        public void setSuspensionStiffness(float value) {
            DynamicsJNI.btRaycastVehicle_btVehicleTuning_suspensionStiffness_set(this.swigCPtr, this, value);
        }

        public float getSuspensionStiffness() {
            return DynamicsJNI.btRaycastVehicle_btVehicleTuning_suspensionStiffness_get(this.swigCPtr, this);
        }

        public void setSuspensionCompression(float value) {
            DynamicsJNI.btRaycastVehicle_btVehicleTuning_suspensionCompression_set(this.swigCPtr, this, value);
        }

        public float getSuspensionCompression() {
            return DynamicsJNI.btRaycastVehicle_btVehicleTuning_suspensionCompression_get(this.swigCPtr, this);
        }

        public void setSuspensionDamping(float value) {
            DynamicsJNI.btRaycastVehicle_btVehicleTuning_suspensionDamping_set(this.swigCPtr, this, value);
        }

        public float getSuspensionDamping() {
            return DynamicsJNI.btRaycastVehicle_btVehicleTuning_suspensionDamping_get(this.swigCPtr, this);
        }

        public void setMaxSuspensionTravelCm(float value) {
            DynamicsJNI.btRaycastVehicle_btVehicleTuning_maxSuspensionTravelCm_set(this.swigCPtr, this, value);
        }

        public float getMaxSuspensionTravelCm() {
            return DynamicsJNI.btRaycastVehicle_btVehicleTuning_maxSuspensionTravelCm_get(this.swigCPtr, this);
        }

        public void setFrictionSlip(float value) {
            DynamicsJNI.btRaycastVehicle_btVehicleTuning_frictionSlip_set(this.swigCPtr, this, value);
        }

        public float getFrictionSlip() {
            return DynamicsJNI.btRaycastVehicle_btVehicleTuning_frictionSlip_get(this.swigCPtr, this);
        }

        public void setMaxSuspensionForce(float value) {
            DynamicsJNI.btRaycastVehicle_btVehicleTuning_maxSuspensionForce_set(this.swigCPtr, this, value);
        }

        public float getMaxSuspensionForce() {
            return DynamicsJNI.btRaycastVehicle_btVehicleTuning_maxSuspensionForce_get(this.swigCPtr, this);
        }
    }
}

