/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.GIM_TRIANGLE_CONTACT;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;
import com.badlogic.gdx.physics.bullet.linearmath.btVector4;

public class btPrimitiveTriangle
extends BulletBase {
    private long swigCPtr;

    protected btPrimitiveTriangle(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btPrimitiveTriangle(long cPtr, boolean cMemoryOwn) {
        this("btPrimitiveTriangle", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btPrimitiveTriangle obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btPrimitiveTriangle(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setVertices(btVector3 value) {
        CollisionJNI.btPrimitiveTriangle_vertices_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getVertices() {
        long cPtr = CollisionJNI.btPrimitiveTriangle_vertices_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setPlane(btVector4 value) {
        CollisionJNI.btPrimitiveTriangle_plane_set(this.swigCPtr, this, btVector4.getCPtr(value), value);
    }

    public btVector4 getPlane() {
        long cPtr = CollisionJNI.btPrimitiveTriangle_plane_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector4(cPtr, false);
    }

    public void setMargin(float value) {
        CollisionJNI.btPrimitiveTriangle_margin_set(this.swigCPtr, this, value);
    }

    public float getMargin() {
        return CollisionJNI.btPrimitiveTriangle_margin_get(this.swigCPtr, this);
    }

    public void setDummy(float value) {
        CollisionJNI.btPrimitiveTriangle_dummy_set(this.swigCPtr, this, value);
    }

    public float getDummy() {
        return CollisionJNI.btPrimitiveTriangle_dummy_get(this.swigCPtr, this);
    }

    public btPrimitiveTriangle() {
        this(CollisionJNI.new_btPrimitiveTriangle(), true);
    }

    public void buildTriPlane() {
        CollisionJNI.btPrimitiveTriangle_buildTriPlane(this.swigCPtr, this);
    }

    public boolean overlap_test_conservative(btPrimitiveTriangle other) {
        return CollisionJNI.btPrimitiveTriangle_overlap_test_conservative(this.swigCPtr, this, btPrimitiveTriangle.getCPtr(other), other);
    }

    public void get_edge_plane(int edge_index, btVector4 plane) {
        CollisionJNI.btPrimitiveTriangle_get_edge_plane(this.swigCPtr, this, edge_index, btVector4.getCPtr(plane), plane);
    }

    public void applyTransform(Matrix4 t) {
        CollisionJNI.btPrimitiveTriangle_applyTransform(this.swigCPtr, this, t);
    }

    public int clip_triangle(btPrimitiveTriangle other, btVector3 clipped_points) {
        return CollisionJNI.btPrimitiveTriangle_clip_triangle(this.swigCPtr, this, btPrimitiveTriangle.getCPtr(other), other, btVector3.getCPtr(clipped_points), clipped_points);
    }

    public boolean find_triangle_collision_clip_method(btPrimitiveTriangle other, GIM_TRIANGLE_CONTACT contacts) {
        return CollisionJNI.btPrimitiveTriangle_find_triangle_collision_clip_method(this.swigCPtr, this, btPrimitiveTriangle.getCPtr(other), other, GIM_TRIANGLE_CONTACT.getCPtr(contacts), contacts);
    }
}

