/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.GIM_BOX_BOX_TRANSFORM_CACHE;
import com.badlogic.gdx.physics.bullet.collision.SWIGTYPE_p_GREAL;
import com.badlogic.gdx.physics.bullet.collision.SWIGTYPE_p_float;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;
import com.badlogic.gdx.physics.bullet.linearmath.btVector4;

public class GIM_AABB
extends BulletBase {
    private long swigCPtr;

    protected GIM_AABB(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public GIM_AABB(long cPtr, boolean cMemoryOwn) {
        this("GIM_AABB", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(GIM_AABB obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_GIM_AABB(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setMin(btVector3 value) {
        CollisionJNI.GIM_AABB_min_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getMin() {
        long cPtr = CollisionJNI.GIM_AABB_min_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setMax(btVector3 value) {
        CollisionJNI.GIM_AABB_max_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getMax() {
        long cPtr = CollisionJNI.GIM_AABB_max_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public GIM_AABB() {
        this(CollisionJNI.new_GIM_AABB__SWIG_0(), true);
    }

    public GIM_AABB(Vector3 V1, Vector3 V2, Vector3 V3) {
        this(CollisionJNI.new_GIM_AABB__SWIG_1(V1, V2, V3), true);
    }

    public GIM_AABB(Vector3 V1, Vector3 V2, Vector3 V3, SWIGTYPE_p_GREAL margin) {
        this(CollisionJNI.new_GIM_AABB__SWIG_2(V1, V2, V3, SWIGTYPE_p_GREAL.getCPtr(margin)), true);
    }

    public GIM_AABB(GIM_AABB other) {
        this(CollisionJNI.new_GIM_AABB__SWIG_3(GIM_AABB.getCPtr(other), other), true);
    }

    public GIM_AABB(GIM_AABB other, float margin) {
        this(CollisionJNI.new_GIM_AABB__SWIG_4(GIM_AABB.getCPtr(other), other, margin), true);
    }

    public void invalidate() {
        CollisionJNI.GIM_AABB_invalidate(this.swigCPtr, this);
    }

    public void increment_margin(float margin) {
        CollisionJNI.GIM_AABB_increment_margin(this.swigCPtr, this, margin);
    }

    public void copy_with_margin(GIM_AABB other, float margin) {
        CollisionJNI.GIM_AABB_copy_with_margin(this.swigCPtr, this, GIM_AABB.getCPtr(other), other, margin);
    }

    public void appy_transform(Matrix4 trans) {
        CollisionJNI.GIM_AABB_appy_transform(this.swigCPtr, this, trans);
    }

    public void merge(GIM_AABB box) {
        CollisionJNI.GIM_AABB_merge(this.swigCPtr, this, GIM_AABB.getCPtr(box), box);
    }

    public void get_center_extend(Vector3 center, Vector3 extend) {
        CollisionJNI.GIM_AABB_get_center_extend(this.swigCPtr, this, center, extend);
    }

    public void find_intersection(GIM_AABB other, GIM_AABB intersection) {
        CollisionJNI.GIM_AABB_find_intersection(this.swigCPtr, this, GIM_AABB.getCPtr(other), other, GIM_AABB.getCPtr(intersection), intersection);
    }

    public boolean has_collision(GIM_AABB other) {
        return CollisionJNI.GIM_AABB_has_collision(this.swigCPtr, this, GIM_AABB.getCPtr(other), other);
    }

    public boolean collide_ray(Vector3 vorigin, Vector3 vdir) {
        return CollisionJNI.GIM_AABB_collide_ray(this.swigCPtr, this, vorigin, vdir);
    }

    public void projection_interval(Vector3 direction, SWIGTYPE_p_float vmin, SWIGTYPE_p_float vmax) {
        CollisionJNI.GIM_AABB_projection_interval(this.swigCPtr, this, direction, SWIGTYPE_p_float.getCPtr(vmin), SWIGTYPE_p_float.getCPtr(vmax));
    }

    public int plane_classify(btVector4 plane) {
        return CollisionJNI.GIM_AABB_plane_classify(this.swigCPtr, this, btVector4.getCPtr(plane), plane);
    }

    public boolean overlapping_trans_conservative(GIM_AABB box, Matrix4 trans1_to_0) {
        return CollisionJNI.GIM_AABB_overlapping_trans_conservative(this.swigCPtr, this, GIM_AABB.getCPtr(box), box, trans1_to_0);
    }

    public boolean overlapping_trans_cache(GIM_AABB box, GIM_BOX_BOX_TRANSFORM_CACHE transcache, boolean fulltest) {
        return CollisionJNI.GIM_AABB_overlapping_trans_cache(this.swigCPtr, this, GIM_AABB.getCPtr(box), box, GIM_BOX_BOX_TRANSFORM_CACHE.getCPtr(transcache), transcache, fulltest);
    }

    public boolean collide_plane(btVector4 plane) {
        return CollisionJNI.GIM_AABB_collide_plane(this.swigCPtr, this, btVector4.getCPtr(plane), plane);
    }

    public boolean collide_triangle_exact(Vector3 p1, Vector3 p2, Vector3 p3, btVector4 triangle_plane) {
        return CollisionJNI.GIM_AABB_collide_triangle_exact(this.swigCPtr, this, p1, p2, p3, btVector4.getCPtr(triangle_plane), triangle_plane);
    }
}

