/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.systems;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.utils.Array;
import java.util.Comparator;

public abstract class SortedIteratingSystem
extends EntitySystem
implements EntityListener {
    private Family family;
    private Array<Entity> sortedEntities;
    private final ImmutableArray<Entity> entities;
    private boolean shouldSort;
    private Comparator<Entity> comparator;

    public SortedIteratingSystem(Family family, Comparator<Entity> comparator) {
        this(family, comparator, 0);
    }

    public SortedIteratingSystem(Family family, Comparator<Entity> comparator, int priority) {
        super(priority);
        this.family = family;
        this.sortedEntities = new Array(false, 16);
        this.entities = new ImmutableArray<Entity>(this.sortedEntities);
        this.comparator = comparator;
    }

    public void forceSort() {
        this.shouldSort = true;
    }

    private void sort() {
        if (this.shouldSort) {
            this.sortedEntities.sort(this.comparator);
            this.shouldSort = false;
        }
    }

    @Override
    public void addedToEngine(Engine engine) {
        ImmutableArray<Entity> newEntities = engine.getEntitiesFor(this.family);
        this.sortedEntities.clear();
        if (newEntities.size() > 0) {
            for (int i = 0; i < newEntities.size(); ++i) {
                this.sortedEntities.add(newEntities.get(i));
            }
            this.sortedEntities.sort(this.comparator);
        }
        this.shouldSort = false;
        engine.addEntityListener(this.family, (EntityListener)this);
    }

    @Override
    public void removedFromEngine(Engine engine) {
        engine.removeEntityListener(this);
        this.sortedEntities.clear();
        this.shouldSort = false;
    }

    @Override
    public void entityAdded(Entity entity) {
        this.sortedEntities.add(entity);
        this.shouldSort = true;
    }

    @Override
    public void entityRemoved(Entity entity) {
        this.sortedEntities.removeValue(entity, true);
        this.shouldSort = true;
    }

    @Override
    public void update(float deltaTime) {
        this.sort();
        for (int i = 0; i < this.sortedEntities.size; ++i) {
            this.processEntity(this.sortedEntities.get(i), deltaTime);
        }
    }

    public ImmutableArray<Entity> getEntities() {
        this.sort();
        return this.entities;
    }

    public Family getFamily() {
        return this.family;
    }

    protected abstract void processEntity(Entity var1, float var2);
}

