/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.systems;

import com.badlogic.ashley.core.EntitySystem;

public abstract class IntervalSystem
extends EntitySystem {
    private float interval;
    private float accumulator;

    public IntervalSystem(float interval) {
        this(interval, 0);
    }

    public IntervalSystem(float interval, int priority) {
        super(priority);
        this.interval = interval;
        this.accumulator = 0.0f;
    }

    public float getInterval() {
        return this.interval;
    }

    @Override
    public void update(float deltaTime) {
        this.accumulator += deltaTime;
        while (this.accumulator >= this.interval) {
            this.accumulator -= this.interval;
            this.updateInterval();
        }
    }

    protected abstract void updateInterval();
}

