/*
 * Decompiled with CFR 0.152.
 */
package io.maze.screens;

import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import io.maze.core.LeaderboardManager;
import io.maze.core.Main;
import io.maze.screens.GameScreen;
import io.maze.screens.MainMenu;
import io.maze.screens.UIUtils;

public class WinScreen
implements Screen {
    private int correctAnswers;
    private int totalEvents;
    private final Main game;
    private final GameScreen gameScreen;
    private final UIUtils ui;

    public WinScreen(final Main game, GameScreen gameScreen, int correctAnswers, int totalEvents) {
        this.game = game;
        this.gameScreen = gameScreen;
        this.correctAnswers = correctAnswers;
        this.totalEvents = totalEvents;
        this.ui = new UIUtils();
        String answerString = new String();
        String eventString = new String();
        ChangeListener backListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.setScreen(new MainMenu(game));
                WinScreen.this.dispose();
            }
        };
        ChangeListener newGameListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.setScreen(new GameScreen(game));
                WinScreen.this.dispose();
            }
        };
        TextButton[] buttons = new TextButton[]{this.ui.createButton("NEW GAME", newGameListener), this.ui.createButton("BACK TO MAIN MENU", backListener)};
        answerString = correctAnswers == 10 ? String.format("All questions answered correctly: +50 points", new Object[0]) : String.format("Correct exam answers: %d", correctAnswers);
        eventString = totalEvents == 11 ? "All events interacted with: +20 points" : String.format("Events interacted with: %d", totalEvents);
        this.ui.appendLabel("You Win!", Color.GREEN);
        this.ui.appendLabel(String.format("Score = %d", this.gameScreen.getScore()), Color.GREEN);
        this.ui.appendLabel("Your Achievements", Color.GREEN);
        this.ui.appendLabel(answerString, Color.GREEN);
        this.ui.appendLabel(eventString, Color.GREEN);
        this.ui.appendButtons(buttons);
        LeaderboardManager manager = new LeaderboardManager();
        manager.addScore("Player", gameScreen.getScore());
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        this.ui.render(delta, Color.BLACK);
    }

    @Override
    public void resize(int width, int height) {
        this.ui.resize(width, height);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.ui.dispose();
    }
}

