/*
 * Decompiled with CFR 0.152.
 */
package io.maze.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.FitViewport;

public class UIUtils {
    private static final int UI_WIDTH = 1920;
    private static final int UI_HEIGHT = 1080;
    private static final int PADDING = 60;
    private static final float IMG_SCALING = 4.0f;
    private final Stage stage;
    private final Table table = new Table();
    private static final Skin uiSkin = new Skin(Gdx.files.internal("ui/ui.json"));

    public UIUtils() {
        this.stage = this.createNewStage(this.table);
    }

    public static Skin getUiSkin() {
        return uiSkin;
    }

    public Table getTable() {
        return this.table;
    }

    public Stage getStage() {
        return this.stage;
    }

    public void appendLabel(String text) {
        Label label = new Label((CharSequence)text, UIUtils.getUiSkin());
        label.setAlignment(1);
        this.table.add(label).center().padBottom(60.0f).row();
    }

    public void appendLabel(String text, Color color) {
        Label label = new Label((CharSequence)text, UIUtils.getUiSkin());
        label.setColor(color);
        label.setAlignment(1);
        this.table.add(label).center().padBottom(60.0f).row();
    }

    public void appendButton(String label, ChangeListener pressEvent) {
        TextButton button = new TextButton(label, UIUtils.getUiSkin());
        button.addListener(pressEvent);
        Cell<TextButton> buttonCell = this.table.add(button);
        buttonCell.space(60.0f);
        buttonCell.row();
    }

    public TextButton createButton(String label, ChangeListener pressEvent) {
        TextButton button = new TextButton(label, UIUtils.getUiSkin());
        button.addListener(pressEvent);
        return button;
    }

    public void appendButtons(TextButton[] buttons) {
        Table buttonTable = new Table();
        buttonTable.center();
        for (TextButton button : buttons) {
            buttonTable.add(button).width(420.0f).height(70.0f).pad(60.0f);
        }
        this.table.add(buttonTable).center().padTop(60.0f).row();
    }

    public Image createImage(String path) {
        Texture texture = new Texture(path);
        Image image = new Image(texture);
        image.setScale(4.0f, 4.0f);
        return image;
    }

    public void appendImageRow(String text, String imagePath) {
        Image image = this.createImage(imagePath);
        Label label = new Label((CharSequence)text, UIUtils.getUiSkin());
        label.setAlignment(8);
        Table rowTable = new Table();
        rowTable.add(image).padRight(160.0f).padTop(30.0f);
        rowTable.add(label).left().padBottom(10.0f);
        this.table.add(rowTable).center().padBottom(20.0f).row();
    }

    public void dispose() {
        this.stage.dispose();
    }

    public void render(float delta, Color color) {
        ScreenUtils.clear(color);
        this.stage.act(delta);
        this.stage.draw();
    }

    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
        this.stage.getViewport().apply();
    }

    private Stage createNewStage(Table table) {
        Stage stage = new Stage(new FitViewport(1920.0f, 1080.0f));
        table.setFillParent(true);
        stage.addActor(table);
        Gdx.input.setInputProcessor(stage);
        return stage;
    }
}

