/*
 * Decompiled with CFR 0.152.
 */
package io.maze.screens;

import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import io.maze.core.Main;
import io.maze.screens.GameScreen;
import io.maze.screens.MainMenu;
import io.maze.screens.UIUtils;

public class TutorialScreen
implements Screen {
    private final Main game;
    private final UIUtils ui;

    public TutorialScreen(final Main game) {
        this.game = game;
        this.ui = new UIUtils();
        ChangeListener playListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.setScreen(new GameScreen(game));
                TutorialScreen.this.dispose();
            }
        };
        ChangeListener backListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.setScreen(new MainMenu(game));
                TutorialScreen.this.dispose();
            }
        };
        TextButton[] buttons = new TextButton[]{this.ui.createButton("BACK", backListener), this.ui.createButton("PLAY", playListener)};
        this.ui.appendImageRow("Use WASD to move", "menu/WASDKeys.png");
        this.ui.appendImageRow("Press E to interact", "menu/eKey.png");
        this.ui.appendImageRow("Press ESC to pause the game", "menu/escKey.png");
        this.ui.appendImageRow("Press T teleport through nearby portals", "menu/tKey.png");
        this.ui.appendImageRow("Apples give speed boosts", "objects/appleClear.png");
        this.ui.appendImageRow("Cookies give extra time", "objects/cookieClear.png");
        this.ui.appendImageRow("Rotten apples slow you down", "objects/badAppleClear.png");
        this.ui.appendButtons(buttons);
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        this.ui.render(delta, Color.SLATE);
    }

    @Override
    public void resize(int width, int height) {
        this.ui.resize(width, height);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.ui.dispose();
    }
}

