/*
 * Decompiled with CFR 0.152.
 */
package io.maze.screens;

import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import io.maze.core.Main;
import io.maze.screens.GameScreen;
import io.maze.screens.MainMenu;
import io.maze.screens.UIUtils;

public class PauseScreen
implements Screen {
    final Main game;
    final GameScreen gameScreen;
    private final UIUtils ui;

    public PauseScreen(final Main game, final GameScreen gameScreen) {
        this.game = game;
        this.gameScreen = gameScreen;
        this.ui = new UIUtils();
        ChangeListener resumeListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.setScreen(gameScreen);
                gameScreen.unPause();
                PauseScreen.this.dispose();
            }
        };
        this.ui.appendButton("RESUME", resumeListener);
        ChangeListener settingsListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                System.out.println("Settings have not been implemented yet.");
            }
        };
        this.ui.appendButton("SETTINGS", settingsListener);
        ChangeListener exitListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.setScreen(new MainMenu(game));
            }
        };
        this.ui.appendButton("QUIT TO MAIN MENU", exitListener);
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        this.ui.render(delta, Color.BLACK);
    }

    @Override
    public void resize(int width, int height) {
        this.ui.resize(width, height);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.ui.dispose();
    }
}

