/*
 * Decompiled with CFR 0.152.
 */
package io.maze.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import io.maze.core.Main;
import io.maze.screens.LeaderboardScreen;
import io.maze.screens.TutorialScreen;
import io.maze.screens.UIUtils;

public class MainMenu
implements Screen {
    final Main game;
    private final UIUtils ui;

    public MainMenu(Main game) {
        this.game = game;
        this.ui = new UIUtils();
        ChangeListener playListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MainMenu.this.onPlayButtonPressed();
            }
        };
        this.ui.appendButton("PLAY", playListener);
        ChangeListener settingsListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                System.out.println("Settings have not been implemented yet.");
            }
        };
        this.ui.appendButton("SETTINGS", settingsListener);
        ChangeListener leaderboardListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MainMenu.this.onLeaderboardButtonPressed();
            }
        };
        this.ui.appendButton("LEADERBOARD", leaderboardListener);
        ChangeListener exitListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Gdx.app.exit();
            }
        };
        this.ui.appendButton("EXIT", exitListener);
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        this.ui.render(delta, Color.BLACK);
    }

    @Override
    public void resize(int width, int height) {
        this.ui.resize(width, height);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.ui.dispose();
    }

    private void onPlayButtonPressed() {
        this.game.setScreen(new TutorialScreen(this.game));
        this.dispose();
    }

    private void onLeaderboardButtonPressed() {
        this.game.setScreen(new LeaderboardScreen(this.game));
        this.dispose();
    }
}

