/*
 * Decompiled with CFR 0.152.
 */
package io.maze.screens;

import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import io.maze.core.LeaderboardManager;
import io.maze.core.Main;
import io.maze.core.ScoreEntry;
import io.maze.screens.MainMenu;
import io.maze.screens.UIUtils;
import java.util.List;

public class LeaderboardScreen
implements Screen {
    private final Main game;
    private final UIUtils ui;
    private final LeaderboardManager leaderboardManager;

    public LeaderboardScreen(final Main game) {
        this.game = game;
        this.ui = new UIUtils();
        this.leaderboardManager = game.getLeaderboardManager();
        List<ScoreEntry> scores = this.leaderboardManager.getScores();
        ChangeListener backListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.setScreen(new MainMenu(game));
                LeaderboardScreen.this.dispose();
            }
        };
        this.ui.appendLabel("LEADERBAORD");
        if (scores.isEmpty()) {
            this.ui.appendLabel("NO SCORES");
        } else {
            for (int i = 0; i < scores.size(); ++i) {
                String entryName;
                ScoreEntry entry = scores.get(i);
                String string = entryName = entry.name == null ? "" : entry.name.trim();
                if (entryName.isEmpty()) {
                    entryName = "Player";
                }
                this.ui.appendLabel(i + 1 + ". " + entryName + " - " + entry.score);
            }
        }
        this.ui.appendButton("BACK", backListener);
    }

    @Override
    public void render(float delta) {
        this.ui.render(delta, Color.BLACK);
    }

    @Override
    public void show() {
    }

    @Override
    public void resize(int width, int height) {
        this.ui.resize(width, height);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.ui.dispose();
    }
}

