/*
 * Decompiled with CFR 0.152.
 */
package io.maze.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.ExtendViewport;
import io.maze.core.Main;
import io.maze.screens.GameScreen;
import java.util.ArrayList;
import java.util.List;

public class KeypadScreen
implements Screen,
InputProcessor {
    private final Main game;
    private final GameScreen gameScreen;
    private final ExtendViewport viewport;
    private BitmapFont font;
    private final SpriteBatch batch;
    private List<Integer> enteredCode;
    private boolean codeCorrect;
    private String statusMessage;
    private Texture buttonTexture;
    private Texture buttonPressedTexture;

    public KeypadScreen(Main game, GameScreen gameScreen) {
        this.game = game;
        this.gameScreen = gameScreen;
        this.batch = game.getBatch();
        this.viewport = new ExtendViewport(16.0f, 9.0f);
        this.font = new BitmapFont();
        this.font.setUseIntegerPositions(false);
        this.font.getData().setScale(0.05f);
        this.font.setColor(Color.WHITE);
        this.enteredCode = new ArrayList<Integer>();
        this.codeCorrect = false;
        this.statusMessage = "Enter a 3-digit code";
        this.buttonTexture = new Texture("objects/buttonInactive.png");
        this.buttonPressedTexture = new Texture("objects/buttonActive.png");
        Gdx.input.setInputProcessor(this);
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(Color.DARK_GRAY);
        this.viewport.apply();
        this.batch.setProjectionMatrix(this.viewport.getCamera().combined);
        this.batch.begin();
        this.font.draw((Batch)this.batch, "SECURITY KEYPAD", 4.6f, 10.8f);
        this.font.draw((Batch)this.batch, this.statusMessage, 5.4f, 8.5f);
        StringBuilder codeDisplay = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            if (i < this.enteredCode.size()) {
                codeDisplay.append(this.enteredCode.get(i));
            } else {
                codeDisplay.append("_");
            }
            if (i >= 2) continue;
            codeDisplay.append(" ");
        }
        this.font.draw((Batch)this.batch, "Code: " + codeDisplay.toString(), 1.5f, 6.4f);
        float buttonSize = 1.2f;
        float startX = 6.0f;
        float startY = 6.0f;
        float spacing = 0.2f;
        String[] labels = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "C", "0", "E"};
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 3; ++col) {
                int index = row * 3 + col;
                if (index >= labels.length) continue;
                float x = startX + (float)col * (buttonSize + spacing);
                float y = startY - (float)row * (buttonSize + spacing);
                this.batch.draw(this.buttonTexture, x, y, buttonSize, buttonSize);
                this.font.draw((Batch)this.batch, labels[index], x + buttonSize / 3.0f, y + buttonSize / 1.5f);
            }
        }
        if (this.codeCorrect) {
            this.font.setColor(Color.GREEN);
            this.font.draw((Batch)this.batch, "ACCESS GRANTED!", 4.4f, 1.5f);
            this.font.setColor(Color.WHITE);
        }
        this.batch.end();
    }

    private void handleButtonPress(String button) {
        if (this.codeCorrect) {
            return;
        }
        switch (button) {
            case "C": {
                this.enteredCode.clear();
                this.statusMessage = "Code cleared";
                break;
            }
            case "E": {
                this.checkCode();
                break;
            }
            default: {
                if (this.enteredCode.size() >= 3 || !button.matches("\\d")) break;
                this.enteredCode.add(Integer.parseInt(button));
                this.statusMessage = "Enter 3-digit code";
                if (this.enteredCode.size() != 3) break;
                this.checkCode();
            }
        }
    }

    private void checkCode() {
        if (this.enteredCode.size() != 3) {
            this.statusMessage = "Enter exactly 3 digits";
            return;
        }
        if (this.enteredCode.get(0) == 7 && this.enteredCode.get(1) == 9 && this.enteredCode.get(2) == 3) {
            this.codeCorrect = true;
            this.statusMessage = "Code correct!";
            if (this.gameScreen != null) {
                this.gameScreen.unlockDoor();
            }
            this.game.setScreen(this.gameScreen);
            this.gameScreen.unPause();
        } else {
            this.statusMessage = "Incorrect code!";
            this.enteredCode.clear();
        }
    }

    public boolean isCodeCorrect() {
        return this.codeCorrect;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        Vector3 touchPos = new Vector3(screenX, screenY, 0.0f);
        this.viewport.getCamera().unproject(touchPos);
        float buttonSize = 1.2f;
        float startX = 6.0f;
        float startY = 6.0f;
        float spacing = 0.2f;
        String[] labels = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "C", "0", "E"};
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 3; ++col) {
                int index = row * 3 + col;
                if (index >= labels.length) continue;
                float x = startX + (float)col * (buttonSize + spacing);
                float y = startY - (float)row * (buttonSize + spacing);
                if (!(touchPos.x >= x) || !(touchPos.x <= x + buttonSize) || !(touchPos.y >= y) || !(touchPos.y <= y + buttonSize)) continue;
                this.handleButtonPress(labels[index]);
                return true;
            }
        }
        return false;
    }

    @Override
    public void show() {
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
        this.viewport.getCamera().position.set(this.viewport.getWorldWidth() / 2.0f, this.viewport.getWorldHeight() / 2.0f, 0.0f);
        this.viewport.getCamera().update();
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        Gdx.input.setInputProcessor(null);
    }

    @Override
    public void dispose() {
        this.font.dispose();
        this.buttonTexture.dispose();
        this.buttonPressedTexture.dispose();
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 111) {
            this.game.setScreen(this.gameScreen);
            this.gameScreen.unPause();
            this.dispose();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(float amountX, float amountY) {
        return false;
    }

    @Override
    public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
        return false;
    }
}

