/*
 * Decompiled with CFR 0.152.
 */
package io.maze.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.FitViewport;
import io.maze.core.CollisionChecker;
import io.maze.core.Inventory;
import io.maze.core.InventoryItem;
import io.maze.core.Main;
import io.maze.entities.Entity;
import io.maze.entities.Guard;
import io.maze.entities.Player;
import io.maze.objects.Exam;
import io.maze.objects.Keypad;
import io.maze.objects.Locker;
import io.maze.objects.Npc;
import io.maze.objects.Portal;
import io.maze.screens.ExamQuestionScreen;
import io.maze.screens.GameOverScreen;
import io.maze.screens.KeypadScreen;
import io.maze.screens.PauseScreen;
import io.maze.screens.WinScreen;
import java.util.ArrayList;
import java.util.List;

public class GameScreen
implements Screen {
    final Main game;
    private final FitViewport viewport;
    private TiledMap map;
    private OrthogonalTiledMapRenderer mapRenderer;
    private final OrthographicCamera camera;
    private final Player player;
    private MapObjects collisionObjects;
    private MapObjects objectObjects;
    private MapObjects checkpointObjects;
    private MapObjects finishObjects;
    private List<String> reachedCheckpoints;
    private ArrayList<Guard> guards;
    private ArrayList<Npc> students;
    private ArrayList<Keypad> keypads;
    private final ArrayList<Exam> exams;
    private List<String> completedExamNames;
    private Boolean isPaused = false;
    private int score = 0;
    private final FitViewport hudViewport;
    private final OrthographicCamera hudCamera;
    private final BitmapFont font;
    private float timeLeft;
    private ArrayList<Locker> lockers;
    private Inventory inventory;
    private BitmapFont inventoryFont;
    private float speedBoostTimer = 0.0f;
    private boolean hasSpeedBoost = false;
    private float origninalPlayerSpeed;
    private Portal portal;
    private String currentMapPath;
    private boolean hasSpeedReduction = false;
    private float immunityTimer = 0.0f;
    private boolean hasImmunity = false;
    private float guardSpeedMultiplier = 1.0f;
    private float guardSpeedTimer = 0.0f;
    private boolean guardsSpedUp = false;
    private boolean examInteractionCounted = false;
    private boolean appleInteractionCounted = false;
    private boolean cookieInteractionCounted = false;
    private boolean guardCollisionCounted = false;
    private boolean rottenAppleCounted = false;
    private boolean doorUnlockedCounted = false;
    private boolean npc4InteractionCounted = false;
    private boolean firstLockerCounted = false;
    private boolean portalUsedCounted = false;
    private boolean studentCardObtained = false;
    private boolean wrongAnswerCounted = false;
    private int correctAnswers = 0;

    public GameScreen(Main game) {
        this.game = game;
        this.map = new TmxMapLoader().load("map/map.tmx");
        this.currentMapPath = "map/map.tmx";
        this.mapRenderer = new OrthogonalTiledMapRenderer(this.map, 0.0625f);
        this.collisionObjects = this.map.getLayers().get("collisions").getObjects();
        this.objectObjects = this.map.getLayers().get("objects").getObjects();
        this.checkpointObjects = this.map.getLayers().get("checkpoints").getObjects();
        this.finishObjects = this.map.getLayers().get("finish").getObjects();
        this.lockers = new ArrayList<Locker>(){
            {
                this.add(new Locker("locker1"));
                this.add(new Locker("locker2"));
                this.add(new Locker("locker3"));
                this.add(new Locker("locker4"));
                this.add(new Locker("locker5"));
                this.add(new Locker("locker6"));
                this.add(new Locker("locker7"));
            }
        };
        this.inventory = new Inventory(3);
        this.inventoryFont = new BitmapFont();
        this.inventoryFont.getData().setScale(0.03f);
        if (this.currentMapPath.equals("map/map.tmx")) {
            this.portal = new Portal("hiddenRoom", "map/hiddenRoom.tmx");
            this.portal.setPosition(this.objectObjects);
        } else {
            this.portal = new Portal("portal", "map/map.tmx");
            this.portal.setPosition(this.objectObjects);
        }
        for (Locker locker : this.lockers) {
            locker.setPosition(this.objectObjects);
        }
        this.camera = new OrthographicCamera();
        this.camera.zoom = 0.65f;
        this.camera.setToOrtho(false, 16.0f, 9.0f);
        this.viewport = new FitViewport(16.0f, 9.0f, this.camera);
        this.player = new Player();
        this.origninalPlayerSpeed = this.player.getSpeed();
        this.guards = new ArrayList<Guard>(){
            {
                this.add(new Guard(19.0f, 28.0f, true, 0.5f));
                this.add(new Guard(15.0f, 43.0f, false, 0.5f));
                this.add(new Guard(13.0f, 43.0f, false, 0.5f));
                this.add(new Guard(11.0f, 43.0f, false, 0.5f));
                this.add(new Guard(9.0f, 43.0f, false, 0.5f));
                this.add(new Guard(11.0f, 36.0f, false, 1.5f));
                this.add(new Guard(15.0f, 36.0f, false, 1.5f));
                this.add(new Guard(14.0f, 17.0f, false, 1.0f));
                this.add(new Guard(17.0f, 17.0f, false, 1.0f));
                this.add(new Guard(27.0f, 16.0f, true, 0.5f));
                this.add(new Guard(4.0f, 5.0f, true, 1.0f));
                this.add(new Guard(4.0f, 7.0f, true, 1.0f));
                this.add(new Guard(21.0f, 12.0f, false, 1.0f));
                this.add(new Guard(9.0f, 23.0f, true, 2.0f));
                this.add(new Guard(15.0f, 3.0f, true, 2.0f));
                this.add(new Guard(30.0f, 5.0f, false, 2.0f));
                this.add(new Guard(32.0f, 5.0f, false, 2.0f));
            }
        };
        this.students = new ArrayList<Npc>(){
            {
                this.add(new Npc("npc1", "npc/npc1.png", "Hey there! Don't forget the\n door keycode like me...\nI'm sure it had a 3 in it"));
                this.add(new Npc("npc2", "npc/npc2.png", "Have you seen the door\nhas been locked again?\nAll I know is it started with a 7"));
                this.add(new Npc("npc3", "npc/npc3.png", "Could you help me?\nI've forgotten the door code \nI can only remember the number 9"));
                this.add(new Npc("npc4", "npc/npc4.png", "I've stolen your student ID card\nyou'll never escape this room now!"));
            }
        };
        for (Npc student : this.students) {
            student.setPosition(this.objectObjects);
        }
        this.exams = new ArrayList<Exam>(){
            {
                this.add(new Exam("exam1", "What is 1 + 2?", "3"));
                this.add(new Exam("exam2", "What is 7 x 6?", "42"));
                this.add(new Exam("exam3", "What is the capital of Germany?", "Berlin"));
                this.add(new Exam("exam4", "What planet is known as the red planet?", "Mars"));
                this.add(new Exam("exam5", "What year did World War II end?", "1945"));
                this.add(new Exam("exam6", "What is the chemical symbol for gold?", "Au"));
                this.add(new Exam("exam7", "What is the main gas that makes up the\nEarth's atmosphere?", "Nitrogen"));
                this.add(new Exam("exam8", "How many continents are there?", "7"));
                this.add(new Exam("exam9", "What is the currency of Japan?", "yen"));
                this.add(new Exam("exam10", "What is the denary number 10 in binary?", "1010"));
            }
        };
        for (Exam exam : this.exams) {
            exam.setPosition(this.objectObjects);
        }
        this.keypads = new ArrayList<Keypad>(){
            {
                this.add(new Keypad("keypad"));
            }
        };
        for (Keypad keypad : this.keypads) {
            keypad.setPosition(this.objectObjects);
        }
        this.completedExamNames = new ArrayList<String>();
        this.completedExamNames.clear();
        this.score = 0;
        this.hudCamera = new OrthographicCamera();
        this.hudCamera.setToOrtho(false, 16.0f, 9.0f);
        this.hudViewport = new FitViewport(16.0f, 9.0f, this.hudCamera);
        this.font = new BitmapFont();
        this.font.setUseIntegerPositions(false);
        this.font.getData().setScale(0.03f);
        this.timeLeft = 300.0f;
    }

    public void unPause() {
        this.isPaused = false;
    }

    @Override
    public void pause() {
        this.isPaused = true;
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public void show() {
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height, true);
        this.hudViewport.update(width, height, true);
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void render(float delta) {
        delta = Math.min(delta, 0.033333335f);
        if (Gdx.input.isKeyJustPressed(111)) {
            this.pause();
            this.game.setScreen(new PauseScreen(this.game, this));
            return;
        }
        this.input(delta);
        this.logic(delta);
        this.draw();
    }

    private void input(float delta) {
        int usedItem;
        if (Gdx.input.isKeyPressed(51)) {
            this.player.setActiveSprite(this.player.getBackSprite());
            this.player.setDeltaY(this.player.getSpeed() * delta);
            this.player.setDeltaX(0.0f);
            if (!CollisionChecker.isColliding(this.player, this.collisionObjects, this.completedExamNames)) {
                this.player.getActiveSprite().translateY(this.player.getDeltaY());
            }
        }
        if (Gdx.input.isKeyPressed(47)) {
            this.player.setActiveSprite(this.player.getFrontSprite());
            this.player.setDeltaY(-this.player.getSpeed() * delta);
            this.player.setDeltaX(0.0f);
            if (!CollisionChecker.isColliding(this.player, this.collisionObjects, this.completedExamNames)) {
                this.player.getActiveSprite().translateY(this.player.getDeltaY());
            }
        }
        if (Gdx.input.isKeyPressed(29)) {
            this.player.setActiveSprite(this.player.getLeftSprite());
            this.player.setDeltaX(-this.player.getSpeed() * delta);
            this.player.setDeltaY(0.0f);
            if (!CollisionChecker.isColliding(this.player, this.collisionObjects, this.completedExamNames)) {
                this.player.getActiveSprite().translateX(this.player.getDeltaX());
            }
        }
        if (Gdx.input.isKeyPressed(32)) {
            this.player.setActiveSprite(this.player.getRightSprite());
            this.player.setDeltaX(this.player.getSpeed() * delta);
            this.player.setDeltaY(0.0f);
            if (!CollisionChecker.isColliding(this.player, this.collisionObjects, this.completedExamNames)) {
                this.player.getActiveSprite().translateX(this.player.getDeltaX());
            }
        }
        if (Gdx.input.isKeyPressed(8) && (usedItem = this.inventory.useItem(0)) != 0) {
            this.applyItemEffect(usedItem);
        }
        if (Gdx.input.isKeyPressed(9) && (usedItem = this.inventory.useItem(1)) != 0) {
            this.applyItemEffect(usedItem);
        }
        if (Gdx.input.isKeyPressed(10) && (usedItem = this.inventory.useItem(2)) != 0) {
            this.applyItemEffect(usedItem);
        }
        if (Gdx.input.isKeyJustPressed(33)) {
            for (Exam exam : this.exams) {
                if (!CollisionChecker.isColliding(this.player, exam) || exam.isCompleted()) continue;
                this.pause();
                this.game.setScreen(new ExamQuestionScreen(this.game, this, exam.getQuestion(), exam.getCorrectAnswer()));
                exam.setCompleted();
                this.score += 100;
                this.completedExamNames.add(exam.getName());
                if (this.examInteractionCounted) break;
                this.examInteractionCounted = true;
                break;
            }
            for (Locker locker : this.lockers) {
                if (!CollisionChecker.isColliding(this.player, locker) || locker.isOpened()) continue;
                int item = locker.open();
                if (item != 0) {
                    this.inventory.addItem(item);
                    if (item == 4 && !this.studentCardObtained) {
                        this.studentCardObtained = true;
                    }
                }
                if (this.firstLockerCounted) continue;
                this.firstLockerCounted = true;
            }
            for (Keypad keypad : this.keypads) {
                if (!CollisionChecker.isColliding(this.player, keypad) || keypad.isActivated()) continue;
                this.game.setScreen(new KeypadScreen(this.game, this));
                this.pause();
                break;
            }
        }
        if (Gdx.input.isKeyJustPressed(48) && CollisionChecker.isColliding(this.player, this.portal) && !this.portal.isActivated()) {
            if (this.currentMapPath.equals("map/hiddenRoom.tmx") && !this.hasStudentCard()) {
                return;
            }
            this.portal.setActivated(true);
            if (!this.portalUsedCounted) {
                this.portalUsedCounted = true;
            }
            if (this.currentMapPath.equals("map/map.tmx")) {
                this.loadNewMap("map/hiddenRoom.tmx");
            } else {
                this.loadNewMap("map/map.tmx");
            }
        }
    }

    private void logic(float delta) {
        if (this.hasImmunity) {
            this.immunityTimer -= delta;
            if (this.immunityTimer <= 0.0f) {
                this.hasImmunity = false;
            }
        }
        if (this.guardsSpedUp) {
            this.guardSpeedTimer -= delta;
            if (this.guardSpeedTimer <= 0.0f) {
                this.guardsSpedUp = false;
                this.guardSpeedMultiplier = 1.0f;
            }
        }
        if (this.hasSpeedBoost || this.hasSpeedReduction) {
            this.speedBoostTimer -= delta;
            if (this.speedBoostTimer <= 0.0f) {
                this.player.setSpeed(this.origninalPlayerSpeed);
                this.hasSpeedBoost = false;
                this.hasSpeedReduction = false;
            }
        }
        if (CollisionChecker.isColliding((Entity)this.player, this.checkpointObjects)) {
            this.player.setSpawnPoint(this.player.getX(), this.player.getY());
        }
        if (CollisionChecker.isColliding((Entity)this.player, this.finishObjects)) {
            this.score += (int)this.timeLeft;
            int totalEvents = 0;
            if (this.guardCollisionCounted) {
                ++totalEvents;
            }
            if (this.rottenAppleCounted) {
                ++totalEvents;
            }
            if (this.doorUnlockedCounted) {
                ++totalEvents;
            }
            if (this.npc4InteractionCounted) {
                ++totalEvents;
            }
            if (this.wrongAnswerCounted) {
                ++totalEvents;
            }
            if (this.firstLockerCounted) {
                ++totalEvents;
            }
            if (this.portalUsedCounted) {
                ++totalEvents;
            }
            if (this.studentCardObtained) {
                ++totalEvents;
            }
            if (this.examInteractionCounted) {
                ++totalEvents;
            }
            if (this.appleInteractionCounted) {
                ++totalEvents;
            }
            if (this.cookieInteractionCounted) {
                ++totalEvents;
            }
            if (totalEvents == 11) {
                this.score += 20;
            }
            if (this.correctAnswers == 10) {
                this.score += 50;
            }
            if ((int)this.timeLeft >= 120) {
                this.score += 20;
            }
            this.game.setScreen(new WinScreen(this.game, this, this.correctAnswers, totalEvents));
        }
        for (Guard guard : this.guards) {
            if (!CollisionChecker.isColliding(this.player, guard) || this.hasImmunity) continue;
            this.player.respawn();
            this.score -= 10;
            if (this.guardCollisionCounted) continue;
            this.guardCollisionCounted = true;
        }
        for (Guard guard : this.guards) {
            if (guard.isMovingHorizontally()) {
                if (guard.getSpeed() < 0.0f) {
                    guard.setActiveSprite(guard.getLeftSprite());
                } else {
                    guard.setActiveSprite(guard.getRightSprite());
                }
                guard.setDeltaX(guard.getSpeed() * this.guardSpeedMultiplier * delta);
                guard.setDeltaY(0.0f);
                guard.getActiveSprite().translateX(guard.getDeltaX());
            } else {
                if (guard.getSpeed() < 0.0f) {
                    guard.setActiveSprite(guard.getFrontSprite());
                } else {
                    guard.setActiveSprite(guard.getBackSprite());
                }
                guard.setDeltaY(guard.getSpeed() * this.guardSpeedMultiplier * delta);
                guard.setDeltaX(0.0f);
                guard.getActiveSprite().translateY(guard.getDeltaY());
            }
            if (!CollisionChecker.isColliding(guard, this.collisionObjects)) continue;
            guard.setSpeed(-guard.getSpeed());
        }
        for (Npc student : this.students) {
            float distanceY;
            float distanceX;
            float distance;
            student.update(this.player);
            if (!student.getName().equals("npc4") || !((distance = (float)Math.sqrt((distanceX = Math.abs(this.player.getX() - student.getSprite().getX())) * distanceX + (distanceY = Math.abs(this.player.getY() - student.getSprite().getY())) * distanceY)) < 2.0f) || !Gdx.input.isKeyJustPressed(33) || this.npc4InteractionCounted) continue;
            this.npc4InteractionCounted = true;
        }
        if (this.timeLeft > 0.0f) {
            this.timeLeft -= delta;
        } else {
            this.game.setScreen(new GameOverScreen(this.game));
        }
    }

    private void draw() {
        ScreenUtils.clear(Color.BLACK);
        this.mapRenderer.setView(this.camera);
        this.mapRenderer.render();
        this.viewport.getCamera().position.set(this.player.getCenterX(), this.player.getCenterY(), 0.0f);
        this.viewport.getCamera().update();
        this.viewport.apply();
        this.game.getBatch().setProjectionMatrix(this.viewport.getCamera().combined);
        this.player.setX(this.player.getActiveSprite().getX());
        this.player.setY(this.player.getActiveSprite().getY());
        this.game.getBatch().begin();
        this.player.updateSpritePositions();
        this.player.getActiveSprite().draw(this.game.getBatch());
        if (this.currentMapPath.equals("map/map.tmx")) {
            for (Guard guard : this.guards) {
                guard.setX(guard.getActiveSprite().getX());
                guard.setY(guard.getActiveSprite().getY());
                guard.updateSpritePositions();
                guard.getActiveSprite().draw(this.game.getBatch());
            }
            for (Npc student : this.students) {
                if (!student.getName().equals("npc4")) {
                    student.getSprite().draw(this.game.getBatch());
                }
                student.renderDialogue(this.game.getBatch());
            }
            for (Exam exam : this.exams) {
                exam.getSprite().draw(this.game.getBatch());
            }
        } else if (this.currentMapPath.equals("map/hiddenRoom.tmx")) {
            for (Npc student : this.students) {
                if (!student.getName().equals("npc4")) continue;
                student.getSprite().draw(this.game.getBatch());
                student.renderDialogue(this.game.getBatch());
            }
        }
        this.game.getBatch().end();
        this.hudViewport.apply();
        this.game.getBatch().setProjectionMatrix(this.hudCamera.combined);
        this.game.getBatch().begin();
        long minutes = (long)Math.floor(this.timeLeft / 60.0f);
        long seconds = (long)Math.floor(this.timeLeft) - minutes * 60L;
        this.font.draw((Batch)this.game.getBatch(), "Time Left: " + String.format("%02d : %02d", minutes, seconds), 12.0f, 8.0f);
        int totalPositiveEvents = 0;
        if (this.examInteractionCounted) {
            ++totalPositiveEvents;
        }
        if (this.appleInteractionCounted) {
            ++totalPositiveEvents;
        }
        if (this.cookieInteractionCounted) {
            ++totalPositiveEvents;
        }
        this.font.draw((Batch)this.game.getBatch(), "Positive Events: " + totalPositiveEvents, 1.0f, 8.0f);
        int totalNegativeEvents = 0;
        if (this.guardCollisionCounted) {
            ++totalNegativeEvents;
        }
        if (this.rottenAppleCounted) {
            ++totalNegativeEvents;
        }
        if (this.doorUnlockedCounted) {
            ++totalNegativeEvents;
        }
        if (this.npc4InteractionCounted) {
            ++totalNegativeEvents;
        }
        if (this.wrongAnswerCounted) {
            ++totalNegativeEvents;
        }
        this.font.draw((Batch)this.game.getBatch(), "Negative Events: " + totalNegativeEvents, 1.0f, 7.5f);
        int totalHiddenEvents = 0;
        if (this.firstLockerCounted) {
            ++totalHiddenEvents;
        }
        if (this.portalUsedCounted) {
            ++totalHiddenEvents;
        }
        if (this.studentCardObtained) {
            ++totalHiddenEvents;
        }
        this.font.draw((Batch)this.game.getBatch(), "Hidden Events: " + totalHiddenEvents, 1.0f, 7.0f);
        for (int i = 0; i < this.inventory.getSlots().size(); ++i) {
            float xPos = 6.8f + (float)i * 1.0f;
            float slotSize = 0.8f;
            this.game.getBatch().draw(this.inventory.getSlots().get(i).getTexture(), xPos, 1.0f, slotSize, slotSize);
            this.inventoryFont.draw((Batch)this.game.getBatch(), String.valueOf(i + 1), xPos + 0.1f, 1.7f);
        }
        String currentPrompt = null;
        for (Exam exam : this.exams) {
            if (!CollisionChecker.isColliding(this.player, exam) || exam.isCompleted()) continue;
            currentPrompt = "Press E to sit exam";
            break;
        }
        if (currentPrompt == null) {
            for (Locker locker : this.lockers) {
                if (!CollisionChecker.isColliding(this.player, locker) || locker.isOpened()) continue;
                currentPrompt = "Press E to open locker";
                break;
            }
        }
        if (currentPrompt == null) {
            for (Keypad keypad : this.keypads) {
                if (!CollisionChecker.isColliding(this.player, keypad) || keypad.isActivated()) continue;
                currentPrompt = "Press E to use keypad";
                break;
            }
        }
        if (currentPrompt == null) {
            for (Npc student : this.students) {
                float distanceY;
                float distanceX = Math.abs(this.player.getX() - student.getSprite().getX());
                float distance = (float)Math.sqrt(distanceX * distanceX + (distanceY = Math.abs(this.player.getY() - student.getSprite().getY())) * distanceY);
                if (!(distance < 2.0f)) continue;
                currentPrompt = "Press E to talk";
                break;
            }
        }
        if (currentPrompt == null && CollisionChecker.isColliding(this.player, this.portal) && !this.portal.isActivated()) {
            currentPrompt = "Press T to teleport";
        }
        if (currentPrompt != null) {
            this.font.setColor(Color.CYAN);
            this.font.draw((Batch)this.game.getBatch(), currentPrompt, 6.5f, 2.2f);
            this.font.setColor(Color.WHITE);
        }
        this.game.getBatch().end();
    }

    @Override
    public void dispose() {
        this.player.dispose();
        this.map.dispose();
        this.mapRenderer.dispose();
        for (Guard guard : this.guards) {
            guard.dispose();
        }
        for (Npc student : this.students) {
            student.dispose();
        }
        for (Exam exam : this.exams) {
            exam.dispose();
        }
        if (this.portal != null) {
            this.portal.dispose();
        }
        this.font.dispose();
    }

    public void unlockDoor() {
        this.completedExamNames.add("lockedDoor");
        if (!this.doorUnlockedCounted) {
            this.doorUnlockedCounted = true;
        }
    }

    private void applyItemEffect(int itemType) {
        switch (itemType) {
            case 1: {
                this.hasSpeedBoost = true;
                this.speedBoostTimer = 10.0f;
                this.player.setSpeed(this.player.getSpeed() + 2.0f);
                if (this.appleInteractionCounted) break;
                this.appleInteractionCounted = true;
                break;
            }
            case 2: {
                this.timeLeft += 15.0f;
                if (this.cookieInteractionCounted) break;
                this.cookieInteractionCounted = true;
                break;
            }
            case 3: {
                this.hasSpeedBoost = false;
                this.hasSpeedReduction = true;
                this.speedBoostTimer = 10.0f;
                this.player.setSpeed(this.player.getSpeed() - 2.0f);
                if (this.rottenAppleCounted) break;
                this.rottenAppleCounted = true;
                break;
            }
        }
    }

    private void loadNewMap(String mapPath) {
        TiledMap newMap;
        this.map.dispose();
        this.mapRenderer.dispose();
        this.lockers.clear();
        this.map = newMap = new TmxMapLoader().load(mapPath);
        this.mapRenderer = new OrthogonalTiledMapRenderer(this.map, 0.0625f);
        this.currentMapPath = mapPath;
        this.mapRenderer.setView(this.camera);
        this.viewport.getCamera().update();
        this.viewport.apply(true);
        this.camera.update();
        this.collisionObjects = this.map.getLayers().get("collisions").getObjects();
        this.objectObjects = this.map.getLayers().get("objects").getObjects();
        this.checkpointObjects = this.map.getLayers().get("checkpoints").getObjects();
        this.finishObjects = this.map.getLayers().get("finish").getObjects();
        this.portal = mapPath.equals("map/map.tmx") ? new Portal("hiddenRoom", "map/hiddenRoom.tmx") : new Portal("portal", "map/map.tmx");
        for (Npc student : this.students) {
            student.setPosition(this.objectObjects);
        }
        for (Locker locker : this.lockers) {
            locker.setPosition(this.objectObjects);
        }
        if (this.portal != null) {
            this.portal.setActivated(false);
            this.portal.setPosition(this.objectObjects);
        }
        if (mapPath.equals("map/map.tmx")) {
            this.player.setX(31.0f);
            this.player.setY(8.0f);
            for (int i = 1; i <= 7; ++i) {
                this.lockers.add(new Locker("locker" + i));
            }
            this.resetGuardPositions();
        } else {
            Locker locker8 = new Locker("locker8");
            this.lockers.add(locker8);
            this.player.setX(16.0f);
            this.player.setY(16.0f);
        }
        this.player.updateSpritePositions();
        for (Locker locker : this.lockers) {
            locker.setPosition(this.objectObjects);
        }
        this.camera.update();
        this.viewport.update(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), true);
        this.mapRenderer.setView(this.camera);
    }

    private void resetGuardPositions() {
        this.guards.clear();
        this.guards = new ArrayList<Guard>(){
            {
                this.add(new Guard(19.0f, 28.0f, true, 0.5f));
                this.add(new Guard(15.0f, 43.0f, false, 0.5f));
                this.add(new Guard(13.0f, 43.0f, false, 0.5f));
                this.add(new Guard(11.0f, 43.0f, false, 0.5f));
                this.add(new Guard(9.0f, 43.0f, false, 0.5f));
                this.add(new Guard(11.0f, 36.0f, false, 1.5f));
                this.add(new Guard(15.0f, 36.0f, false, 1.5f));
                this.add(new Guard(14.0f, 17.0f, false, 1.0f));
                this.add(new Guard(17.0f, 17.0f, false, 1.0f));
                this.add(new Guard(27.0f, 16.0f, true, 0.5f));
                this.add(new Guard(4.0f, 5.0f, true, 1.0f));
                this.add(new Guard(4.0f, 7.0f, true, 1.0f));
                this.add(new Guard(21.0f, 12.0f, false, 1.0f));
                this.add(new Guard(9.0f, 23.0f, true, 2.0f));
                this.add(new Guard(15.0f, 3.0f, true, 2.0f));
                this.add(new Guard(30.0f, 5.0f, false, 2.0f));
                this.add(new Guard(32.0f, 5.0f, false, 2.0f));
            }
        };
    }

    public void handleExamResult(boolean correct) {
        this.unPause();
        if (correct) {
            this.hasImmunity = true;
            this.immunityTimer = 8.0f;
            ++this.correctAnswers;
        } else {
            this.guardSpeedMultiplier = 2.5f;
            this.guardsSpedUp = true;
            this.guardSpeedTimer = 15.0f;
            if (!this.wrongAnswerCounted) {
                this.wrongAnswerCounted = true;
            }
        }
    }

    private boolean hasStudentCard() {
        for (InventoryItem item : this.inventory.getSlots()) {
            if (item.getType() != 4) continue;
            return true;
        }
        return false;
    }
}

