/*
 * Decompiled with CFR 0.152.
 */
package io.maze.screens;

import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import io.maze.core.Main;
import io.maze.screens.GameScreen;
import io.maze.screens.MainMenu;
import io.maze.screens.UIUtils;

public class GameOverScreen
implements Screen {
    private final Main game;
    private final UIUtils ui;

    public GameOverScreen(final Main game) {
        this.game = game;
        this.ui = new UIUtils();
        ChangeListener backListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.setScreen(new MainMenu(game));
                GameOverScreen.this.dispose();
            }
        };
        ChangeListener newGameListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.setScreen(new GameScreen(game));
                GameOverScreen.this.dispose();
            }
        };
        TextButton[] buttons = new TextButton[]{this.ui.createButton("NEW GAME", newGameListener), this.ui.createButton("BACK TO MAIN MENU", backListener)};
        this.ui.appendLabel("GAME OVER!");
        this.ui.appendButtons(buttons);
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        this.ui.render(delta, Color.BLACK);
    }

    @Override
    public void resize(int width, int height) {
        this.ui.resize(width, height);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.ui.dispose();
    }
}

