/*
 * Decompiled with CFR 0.152.
 */
package io.maze.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.ExtendViewport;
import io.maze.core.Main;
import io.maze.screens.GameScreen;

public class ExamQuestionScreen
implements Screen,
InputProcessor {
    private final Main game;
    private final GameScreen gameScreen;
    private final ExtendViewport viewport;
    private BitmapFont font;
    private final SpriteBatch batch;
    private String question;
    private String correctAnswer;
    private StringBuilder userInput;
    private boolean answerSubmitted;
    private boolean isCorrect;

    public ExamQuestionScreen(Main game, GameScreen gameScreen, String question, String correctAnswer) {
        this.game = game;
        this.gameScreen = gameScreen;
        this.batch = game.getBatch();
        this.viewport = new ExtendViewport(16.0f, 9.0f);
        this.font = new BitmapFont();
        this.font.setUseIntegerPositions(false);
        this.font.getData().setScale(0.04f);
        this.font.setColor(Color.WHITE);
        this.question = question;
        this.correctAnswer = correctAnswer.toLowerCase().trim();
        this.userInput = new StringBuilder();
        this.answerSubmitted = false;
        this.isCorrect = false;
        Gdx.input.setInputProcessor(this);
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(Color.DARK_GRAY);
        this.viewport.apply();
        this.batch.setProjectionMatrix(this.viewport.getCamera().combined);
        this.batch.begin();
        this.font.draw((Batch)this.batch, "Exam Question: ", 5.0f, 8.0f);
        this.font.draw((Batch)this.batch, this.question, 1.0f, 7.0f);
        this.font.draw((Batch)this.batch, "Your Answer: ", 1.0f, 5.0f);
        this.font.draw((Batch)this.batch, this.userInput.toString() + (System.currentTimeMillis() % 1000L < 500L ? "|" : ""), 1.0f, 4.5f);
        this.font.draw((Batch)this.batch, "Press ENTER to submit answer", 1.0f, 3.0f);
        this.font.draw((Batch)this.batch, "Press ESC to cancel", 1.0f, 2.5f);
        if (this.answerSubmitted) {
            if (this.isCorrect) {
                this.font.setColor(Color.GREEN);
                this.font.draw((Batch)this.batch, "Correct! Enjoy 8 seconds of immunity from the guards", 1.0f, 2.0f);
            } else {
                this.font.setColor(Color.RED);
                this.font.draw((Batch)this.batch, "Incorrect! The guards are getting quicker...", 1.0f, 2.0f);
            }
            this.font.setColor(Color.WHITE);
            this.font.draw((Batch)this.batch, "Press any key to continue", 1.0f, 1.0f);
        }
        this.batch.end();
    }

    @Override
    public boolean keyDown(int keycode) {
        if (this.answerSubmitted) {
            this.game.setScreen(this.gameScreen);
            this.gameScreen.handleExamResult(this.isCorrect);
            this.dispose();
            return true;
        }
        switch (keycode) {
            case 66: {
                this.submitAnswer();
                return true;
            }
            case 111: {
                this.game.setScreen(this.gameScreen);
                this.gameScreen.unPause();
                this.dispose();
                return true;
            }
            case 67: {
                if (this.userInput.length() > 0) {
                    this.userInput.deleteCharAt(this.userInput.length() - 1);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        if (!this.answerSubmitted && Character.isLetterOrDigit(character) || character == ' ') {
            this.userInput.append(character);
            return true;
        }
        return false;
    }

    private void submitAnswer() {
        this.answerSubmitted = true;
        String userAnswer = this.userInput.toString().toLowerCase().trim();
        this.isCorrect = userAnswer.equals(this.correctAnswer);
    }

    public void handleExamResult(boolean correct) {
        this.gameScreen.handleExamResult(correct);
    }

    @Override
    public void show() {
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
        this.viewport.getCamera().position.set(this.viewport.getWorldWidth() / 2.0f, this.viewport.getWorldHeight() / 2.0f, 0.0f);
        this.viewport.getCamera().update();
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        Gdx.input.setInputProcessor(null);
    }

    @Override
    public void dispose() {
        this.font.dispose();
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(float amountX, float amountY) {
        return false;
    }

    @Override
    public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
        return false;
    }
}

