/*
 * Decompiled with CFR 0.152.
 */
package io.maze.objects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.objects.RectangleMapObject;

public abstract class Object {
    private final Texture texture;
    private final Sprite sprite;
    private final String name;

    public Object(String name, String texturePath) {
        this.name = name;
        this.texture = new Texture(Gdx.files.internal(texturePath));
        this.sprite = new Sprite(this.texture);
        this.sprite.setSize(1.0f, 1.0f);
    }

    public void setPosition(MapObjects objects) {
        for (RectangleMapObject object : objects.getByType(RectangleMapObject.class)) {
            if (!object.getName().equals(this.name)) continue;
            this.sprite.setPosition(object.getRectangle().x / 16.0f, object.getRectangle().y / 16.0f);
        }
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public String getName() {
        return this.name;
    }

    public void dispose() {
        this.texture.dispose();
    }
}

