/*
 * Decompiled with CFR 0.152.
 */
package io.maze.objects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import io.maze.entities.Player;
import io.maze.objects.Object;

public class Npc
extends Object {
    private String dialogue;
    private boolean showMessage = false;
    private BitmapFont font;
    private Vector2 position;
    private Texture tecture;

    public Npc(String name, String texturePath, String dialogue) {
        super(name, texturePath);
        this.dialogue = dialogue;
        this.font = new BitmapFont();
        this.font.getData().setScale(0.025f);
        this.font.setUseIntegerPositions(false);
    }

    public void update(Player player) {
        float distanceY;
        float playerX = player.getX();
        float playerY = player.getY();
        float npcX = this.getSprite().getX();
        float npcY = this.getSprite().getY();
        float distanceX = Math.abs(playerX - npcX);
        float distance = (float)Math.sqrt(distanceX * distanceX + (distanceY = Math.abs(playerY - npcY)) * distanceY);
        if (distance < 2.0f && Gdx.input.isKeyJustPressed(33)) {
            this.showMessage = true;
        }
        if (this.showMessage && distance > 3.0f) {
            this.showMessage = false;
        }
    }

    public void renderDialogue(SpriteBatch batch) {
        if (this.showMessage) {
            this.font.draw((Batch)batch, this.dialogue, this.getSprite().getX() - 2.0f, this.getSprite().getY() + this.getSprite().getHeight() + 1.0f);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.font != null) {
            this.font.dispose();
        }
    }

    public String getDialogue() {
        return this.dialogue;
    }

    public void setDialogue(String dialogue) {
        this.dialogue = dialogue;
    }

    public Vector2 getPosition() {
        return new Vector2(this.getSprite().getX(), this.getSprite().getY());
    }
}

