/*
 * Decompiled with CFR 0.152.
 */
package io.maze.entities;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;

public abstract class Entity {
    private final Texture frontTexture;
    private final Texture backTexture;
    private final Texture leftTexture;
    private final Texture rightTexture;
    private final Sprite frontSprite;
    private final Sprite backSprite;
    private final Sprite leftSprite;
    private final Sprite rightSprite;
    private Sprite activeSprite;
    float x;
    float y;
    protected float speed;
    private float deltaX;
    private float deltaY;

    public Entity(String frontPath, String backPath, String rightPath, String leftPath) {
        this.frontTexture = new Texture(frontPath);
        this.backTexture = new Texture(backPath);
        this.rightTexture = new Texture(rightPath);
        this.leftTexture = new Texture(leftPath);
        this.frontSprite = new Sprite(this.frontTexture);
        this.backSprite = new Sprite(this.backTexture);
        this.rightSprite = new Sprite(this.rightTexture);
        this.leftSprite = new Sprite(this.leftTexture);
        this.frontSprite.setSize(1.0f, 1.0f);
        this.backSprite.setSize(1.0f, 1.0f);
        this.rightSprite.setSize(1.0f, 1.0f);
        this.leftSprite.setSize(1.0f, 1.0f);
        this.activeSprite = this.frontSprite;
        this.x = 0.0f;
        this.y = 0.0f;
        this.speed = 4.0f;
        this.deltaX = 0.0f;
        this.deltaY = 0.0f;
    }

    public void updateSpritePositions() {
        this.frontSprite.setPosition(this.x, this.y);
        this.backSprite.setPosition(this.x, this.y);
        this.leftSprite.setPosition(this.x, this.y);
        this.rightSprite.setPosition(this.x, this.y);
    }

    public float getCenterX() {
        return this.activeSprite.getX() + this.activeSprite.getWidth() / 2.0f;
    }

    public float getCenterY() {
        return this.activeSprite.getY() + this.activeSprite.getHeight() / 2.0f;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public Sprite getActiveSprite() {
        return this.activeSprite;
    }

    public void setActiveSprite(Sprite activeSprite) {
        this.activeSprite = activeSprite;
    }

    public Sprite getFrontSprite() {
        return this.frontSprite;
    }

    public Sprite getBackSprite() {
        return this.backSprite;
    }

    public Sprite getLeftSprite() {
        return this.leftSprite;
    }

    public Sprite getRightSprite() {
        return this.rightSprite;
    }

    public float getDeltaX() {
        return this.deltaX;
    }

    public void setDeltaX(float deltaX) {
        this.deltaX = deltaX;
    }

    public float getDeltaY() {
        return this.deltaY;
    }

    public void setDeltaY(float deltaY) {
        this.deltaY = deltaY;
    }

    public void dispose() {
        this.frontTexture.dispose();
        this.backTexture.dispose();
        this.leftTexture.dispose();
        this.rightTexture.dispose();
    }
}

