/*
 * Decompiled with CFR 0.152.
 */
package io.maze.core;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import io.maze.core.ScoreEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LeaderboardManager {
    private static final String LEADERBOARD_FILE = "leaderboard.json";
    private static final int MAX_SCORES = 5;
    private final Json json = new Json();

    public LeaderboardManager() {
        this.json.setOutputType(JsonWriter.OutputType.json);
    }

    public List<ScoreEntry> getScores() {
        ArrayList<ScoreEntry> scores = this.loadScoresInternal();
        Collections.sort(scores);
        return scores;
    }

    public boolean addScore(String name, int score) {
        String safeName;
        String string = safeName = name == null ? "" : name.trim();
        if (safeName.isEmpty()) {
            safeName = "Player";
        }
        int safeScore = Math.max(score, 0);
        ArrayList<ScoreEntry> scores = this.loadScoresInternal();
        ScoreEntry entry = new ScoreEntry(safeName, safeScore);
        scores.add(entry);
        Collections.sort(scores);
        boolean saved = true;
        while (scores.size() > 5) {
            ScoreEntry removed = scores.remove(scores.size() - 1);
            if (removed != entry) continue;
            saved = false;
            break;
        }
        this.saveScores(scores);
        return saved;
    }

    public boolean isHighScore(int score) {
        if (score <= 0) {
            return false;
        }
        ArrayList<ScoreEntry> scores = this.loadScoresInternal();
        if (scores.size() < 5) {
            return true;
        }
        return score > scores.get((int)(scores.size() - 1)).score;
    }

    private ArrayList<ScoreEntry> loadScoresInternal() {
        FileHandle file = Gdx.files.local(LEADERBOARD_FILE);
        if (!file.exists() || file.length() == 0L) {
            return new ArrayList<ScoreEntry>();
        }
        try {
            ArrayList scores = this.json.fromJson(ArrayList.class, ScoreEntry.class, file);
            if (scores == null) {
                return new ArrayList<ScoreEntry>();
            }
            return scores;
        }
        catch (Exception ex) {
            Gdx.app.error("Leaderboard", "Failed to load leaderboard", ex);
            return new ArrayList<ScoreEntry>();
        }
    }

    private void saveScores(ArrayList<ScoreEntry> scores) {
        FileHandle file = Gdx.files.local(LEADERBOARD_FILE);
        try {
            file.writeString(this.json.prettyPrint(scores), false);
        }
        catch (Exception ex) {
            Gdx.app.error("Leaderboard", "Failed to save leaderboard", ex);
        }
    }
}

