/*
 * Decompiled with CFR 0.152.
 */
package io.maze.core;

import io.maze.core.InventoryItem;
import java.util.ArrayList;
import java.util.List;

public class Inventory {
    private List<InventoryItem> slots = new ArrayList<InventoryItem>();

    public Inventory(int size) {
        for (int i = 0; i < size; ++i) {
            this.slots.add(new InventoryItem());
        }
    }

    public boolean addItem(int itemType) {
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!this.slots.get(i).isEmpty()) continue;
            this.slots.set(i, new InventoryItem(itemType));
            return true;
        }
        return false;
    }

    public int useItem(int slot) {
        if (slot >= 0 && slot < this.slots.size() && !this.slots.get(slot).isEmpty()) {
            int itemType = this.slots.get(slot).getType();
            this.slots.set(slot, new InventoryItem());
            return itemType;
        }
        return 0;
    }

    public List<InventoryItem> getSlots() {
        return this.slots;
    }

    public boolean isFull() {
        for (InventoryItem item : this.slots) {
            if (!item.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        for (InventoryItem item : this.slots) {
            item.dispose();
        }
    }
}

