/*
 * Decompiled with CFR 0.152.
 */
package io.maze.core;

import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.objects.RectangleMapObject;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Rectangle;
import io.maze.entities.Entity;
import io.maze.entities.Player;
import java.util.List;

public class CollisionChecker {
    public static boolean isColliding(Entity entity, MapObjects objects) {
        Rectangle futureHitbox = new Rectangle(entity.getActiveSprite().getX() + entity.getDeltaX(), entity.getActiveSprite().getY() + entity.getDeltaY(), 1.0f, 1.0f);
        for (RectangleMapObject collisionObject : objects.getByType(RectangleMapObject.class)) {
            Rectangle object = collisionObject.getRectangle();
            Rectangle scaledObject = new Rectangle(object.x / 16.0f, object.y / 16.0f, object.width / 16.0f, object.height / 16.0f);
            if (!Intersector.overlaps(scaledObject, futureHitbox)) continue;
            return true;
        }
        return false;
    }

    public static boolean isColliding(Entity entity, MapObjects objects, List<String> exceptions) {
        Rectangle futureHitbox = new Rectangle(entity.getActiveSprite().getX() + entity.getDeltaX(), entity.getActiveSprite().getY() + entity.getDeltaY(), 1.0f, 1.0f);
        for (RectangleMapObject collisionObject : objects.getByType(RectangleMapObject.class)) {
            if (exceptions != null && exceptions.contains(collisionObject.getName())) continue;
            Rectangle object = collisionObject.getRectangle();
            Rectangle scaledObject = new Rectangle(object.x / 16.0f, object.y / 16.0f, object.width / 16.0f, object.height / 16.0f);
            if (!Intersector.overlaps(scaledObject, futureHitbox)) continue;
            return true;
        }
        return false;
    }

    public static boolean isColliding(Player player, Entity entity) {
        Rectangle playerHitbox = new Rectangle(player.getActiveSprite().getX(), player.getActiveSprite().getY(), 1.0f, 1.0f);
        Rectangle entityHitbox = new Rectangle(entity.getActiveSprite().getX(), entity.getActiveSprite().getY(), 1.0f, 1.0f);
        return Intersector.overlaps(playerHitbox, entityHitbox);
    }

    public static boolean isColliding(Player player, io.maze.objects.Object object) {
        Rectangle playerHitbox = new Rectangle(player.getActiveSprite().getX(), player.getActiveSprite().getY(), 1.0f, 1.0f);
        Rectangle objectHitbox = new Rectangle(object.getSprite().getX(), object.getSprite().getY(), 1.0f, 1.0f);
        return Intersector.overlaps(playerHitbox, objectHitbox);
    }
}

