/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.angle;

import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Random;
import java.util.UUID;
import java.util.zip.CRC32;

public class ANGLELoader {
    public static boolean isWindows = System.getProperty("os.name").contains("Windows");
    public static boolean isLinux = System.getProperty("os.name").contains("Linux") || System.getProperty("os.name").contains("FreeBSD");
    public static boolean isMac = System.getProperty("os.name").contains("Mac");
    public static boolean isARM = System.getProperty("os.arch").startsWith("arm") || System.getProperty("os.arch").startsWith("aarch64");
    public static boolean is64Bit = System.getProperty("os.arch").contains("64") || System.getProperty("os.arch").startsWith("armv8");
    private static final Random random = new Random();
    private static File egl;
    private static File gles;
    private static File lastWorkingDir;

    public static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static String randomUUID() {
        return new UUID(random.nextLong(), random.nextLong()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String crc(InputStream input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[4096];
        try {
            int length;
            while ((length = input.read(buffer)) != -1) {
                crc.update(buffer, 0, length);
            }
        }
        catch (Exception exception) {
        }
        finally {
            ANGLELoader.closeQuietly(input);
        }
        return Long.toString(crc.getValue(), 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractFile(String sourcePath, File outFile) {
        File file;
        if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
            throw new GdxRuntimeException("Couldn't create ANGLE native library output directory " + outFile.getParentFile().getAbsolutePath());
        }
        FileOutputStream out = null;
        InputStream in = null;
        if (outFile.exists()) {
            return outFile;
        }
        try {
            int length;
            out = new FileOutputStream(outFile);
            in = ANGLELoader.class.getResourceAsStream("/" + sourcePath);
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            file = outFile;
        }
        catch (Throwable throwable) {
            try {
                ANGLELoader.closeQuietly(out);
                ANGLELoader.closeQuietly(in);
                throw throwable;
            }
            catch (Throwable t) {
                throw new GdxRuntimeException("Couldn't load ANGLE shared library " + sourcePath, t);
            }
        }
        ANGLELoader.closeQuietly(out);
        ANGLELoader.closeQuietly(in);
        return file;
    }

    private static File getExtractedFile(String dirName, String fileName) {
        File file2;
        File idealFile = new File(System.getProperty("java.io.tmpdir") + "/libgdx" + System.getProperty("user.name") + "/" + dirName, fileName);
        if (ANGLELoader.canWrite(idealFile)) {
            return idealFile;
        }
        try {
            file2 = File.createTempFile(dirName, null);
            if (file2.delete() && ANGLELoader.canWrite(file2 = new File(file2, fileName))) {
                return file2;
            }
        }
        catch (IOException file2) {
            // empty catch block
        }
        file2 = new File(System.getProperty("user.home") + "/.libgdx/" + dirName, fileName);
        if (ANGLELoader.canWrite(file2)) {
            return file2;
        }
        file2 = new File(".temp/" + dirName, fileName);
        if (ANGLELoader.canWrite(file2)) {
            return file2;
        }
        if (System.getenv("APP_SANDBOX_CONTAINER_ID") != null) {
            return idealFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(File file) {
        File testFile;
        File parent = file.getParentFile();
        if (file.exists()) {
            if (!file.canWrite() || !ANGLELoader.canExecute(file)) {
                return false;
            }
            testFile = new File(parent, ANGLELoader.randomUUID().toString());
        } else {
            parent.mkdirs();
            if (!parent.isDirectory()) {
                return false;
            }
            testFile = file;
        }
        try {
            new FileOutputStream(testFile).close();
            if (!ANGLELoader.canExecute(testFile)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            testFile.delete();
        }
    }

    private static boolean canExecute(File file) {
        try {
            Method canExecute = File.class.getMethod("canExecute", new Class[0]);
            if (((Boolean)canExecute.invoke((Object)file, new Object[0])).booleanValue()) {
                return true;
            }
            Method setExecutable = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            setExecutable.invoke((Object)file, true, false);
            return (Boolean)canExecute.invoke((Object)file, new Object[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void load() {
        if (isARM && !isMac || !isWindows && !isLinux && !isMac) {
            throw new GdxRuntimeException("ANGLE is only supported on x86/x86_64 Windows, x64 Linux, and x64/arm64 macOS.");
        }
        String osDir = null;
        String ext = null;
        if (isWindows) {
            osDir = is64Bit ? "windows64" : "windows32";
            ext = ".dll";
        }
        if (isLinux) {
            osDir = "linux64";
            ext = ".so";
        }
        if (isMac) {
            osDir = isARM ? "macosxarm64" : "macosx64";
            ext = ".dylib";
        }
        String eglSource = osDir + "/libEGL" + ext;
        String glesSource = osDir + "/libGLESv2" + ext;
        String crc = ANGLELoader.crc(ANGLELoader.class.getResourceAsStream("/" + eglSource)) + ANGLELoader.crc(ANGLELoader.class.getResourceAsStream("/" + glesSource));
        egl = ANGLELoader.getExtractedFile(crc, new File(eglSource).getName());
        gles = ANGLELoader.getExtractedFile(crc, new File(glesSource).getName());
        if (!isMac) {
            ANGLELoader.extractFile(eglSource, egl);
            System.load(egl.getAbsolutePath());
            ANGLELoader.extractFile(glesSource, gles);
            System.load(gles.getAbsolutePath());
        } else {
            lastWorkingDir = new File(".");
            ANGLELoader.extractFile(eglSource, new File(lastWorkingDir, egl.getName()));
            ANGLELoader.extractFile(glesSource, new File(lastWorkingDir, gles.getName()));
        }
    }

    public static void postGlfwInit() {
        new File(lastWorkingDir, egl.getName()).delete();
        new File(lastWorkingDir, gles.getName()).delete();
    }
}

